"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZWaveSerialPort = void 0;
const ZWaveSerialPortBase_1 = require("./ZWaveSerialPortBase");
/** The default version of the Z-Wave serial binding that works using node-serialport */
class ZWaveSerialPort extends ZWaveSerialPortBase_1.ZWaveSerialPortBase {
    constructor(port, loggers, Binding = require("serialport")) {
        super({
            create: () => new Binding(port, {
                autoOpen: false,
                baudRate: 115200,
                dataBits: 8,
                stopBits: 1,
                parity: "none",
            }),
            open: (serial) => new Promise((resolve) => {
                serial.once("open", resolve).open();
            }),
            close: (serial) => new Promise((resolve) => {
                serial.once("close", resolve).close();
            }),
        }, loggers);
    }
    get isOpen() {
        return this.serial.isOpen;
    }
}
exports.ZWaveSerialPort = ZWaveSerialPort;
//# sourceMappingURL=ZWaveSerialPort.js.map