"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimulatedClock = void 0;
var SimulatedClock = /** @class */ (function () {
    function SimulatedClock() {
        this.timeouts = new Map();
        this._now = 0;
        this._id = 0;
    }
    SimulatedClock.prototype.now = function () {
        return this._now;
    };
    SimulatedClock.prototype.getId = function () {
        return this._id++;
    };
    SimulatedClock.prototype.setTimeout = function (fn, timeout) {
        var id = this.getId();
        this.timeouts.set(id, {
            start: this.now(),
            timeout: timeout,
            fn: fn
        });
        return id;
    };
    SimulatedClock.prototype.clearTimeout = function (id) {
        this.timeouts.delete(id);
    };
    SimulatedClock.prototype.set = function (time) {
        if (this._now > time) {
            throw new Error('Unable to travel back in time');
        }
        this._now = time;
        this.flushTimeouts();
    };
    SimulatedClock.prototype.flushTimeouts = function () {
        var _this = this;
        __spreadArray([], __read(this.timeouts)).sort(function (_a, _b) {
            var _c = __read(_a, 2), _idA = _c[0], timeoutA = _c[1];
            var _d = __read(_b, 2), _idB = _d[0], timeoutB = _d[1];
            var endA = timeoutA.start + timeoutA.timeout;
            var endB = timeoutB.start + timeoutB.timeout;
            return endB > endA ? -1 : 1;
        })
            .forEach(function (_a) {
            var _b = __read(_a, 2), id = _b[0], timeout = _b[1];
            if (_this.now() - timeout.start >= timeout.timeout) {
                _this.timeouts.delete(id);
                timeout.fn.call(null);
            }
        });
    };
    SimulatedClock.prototype.increment = function (ms) {
        this._now += ms;
        this.flushTimeouts();
    };
    return SimulatedClock;
}());
exports.SimulatedClock = SimulatedClock;
