"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.State = exports.bindActionToState = exports.isState = exports.stateValuesEqual = void 0;
var constants_1 = require("./constants");
var utils_1 = require("./utils");
var stateUtils_1 = require("./stateUtils");
var actions_1 = require("./actions");
function stateValuesEqual(a, b) {
    if (a === b) {
        return true;
    }
    if (a === undefined || b === undefined) {
        return false;
    }
    if (utils_1.isString(a) || utils_1.isString(b)) {
        return a === b;
    }
    var aKeys = utils_1.keys(a);
    var bKeys = utils_1.keys(b);
    return (aKeys.length === bKeys.length &&
        aKeys.every(function (key) { return stateValuesEqual(a[key], b[key]); }));
}
exports.stateValuesEqual = stateValuesEqual;
function isState(state) {
    if (utils_1.isString(state)) {
        return false;
    }
    return 'value' in state && 'history' in state;
}
exports.isState = isState;
function bindActionToState(action, state) {
    var exec = action.exec;
    var boundAction = __assign(__assign({}, action), { exec: exec !== undefined
            ? function () {
                return exec(state.context, state.event, {
                    action: action,
                    state: state,
                    _event: state._event
                });
            }
            : undefined });
    return boundAction;
}
exports.bindActionToState = bindActionToState;
var State = /** @class */ (function () {
    /**
     * Creates a new State instance.
     * @param value The state value
     * @param context The extended state
     * @param historyValue The tree representing historical values of the state nodes
     * @param history The previous state
     * @param actions An array of action objects to execute as side-effects
     * @param activities A mapping of activities and whether they are started (`true`) or stopped (`false`).
     * @param meta
     * @param events Internal event queue. Should be empty with run-to-completion semantics.
     * @param configuration
     */
    function State(config) {
        var _this = this;
        var _a;
        this.actions = [];
        this.activities = constants_1.EMPTY_ACTIVITY_MAP;
        this.meta = {};
        this.events = [];
        this.value = config.value;
        this.context = config.context;
        this._event = config._event;
        this._sessionid = config._sessionid;
        this.event = this._event.data;
        this.historyValue = config.historyValue;
        this.history = config.history;
        this.actions = config.actions || [];
        this.activities = config.activities || constants_1.EMPTY_ACTIVITY_MAP;
        this.meta = config.meta || {};
        this.events = config.events || [];
        this.matches = this.matches.bind(this);
        this.toStrings = this.toStrings.bind(this);
        this.configuration = config.configuration;
        this.transitions = config.transitions;
        this.children = config.children;
        this.done = !!config.done;
        this.tags = (_a = config.tags) !== null && _a !== void 0 ? _a : new Set();
        Object.defineProperty(this, 'nextEvents', {
            get: function () {
                return stateUtils_1.nextEvents(_this.configuration);
            }
        });
    }
    /**
     * Creates a new State instance for the given `stateValue` and `context`.
     * @param stateValue
     * @param context
     */
    State.from = function (stateValue, context) {
        if (stateValue instanceof State) {
            if (stateValue.context !== context) {
                return new State({
                    value: stateValue.value,
                    context: context,
                    _event: stateValue._event,
                    _sessionid: null,
                    historyValue: stateValue.historyValue,
                    history: stateValue.history,
                    actions: [],
                    activities: stateValue.activities,
                    meta: {},
                    events: [],
                    configuration: [],
                    transitions: [],
                    children: {}
                });
            }
            return stateValue;
        }
        var _event = actions_1.initEvent;
        return new State({
            value: stateValue,
            context: context,
            _event: _event,
            _sessionid: null,
            historyValue: undefined,
            history: undefined,
            actions: [],
            activities: undefined,
            meta: undefined,
            events: [],
            configuration: [],
            transitions: [],
            children: {}
        });
    };
    /**
     * Creates a new State instance for the given `config`.
     * @param config The state config
     */
    State.create = function (config) {
        return new State(config);
    };
    /**
     * Creates a new `State` instance for the given `stateValue` and `context` with no actions (side-effects).
     * @param stateValue
     * @param context
     */
    State.inert = function (stateValue, context) {
        if (stateValue instanceof State) {
            if (!stateValue.actions.length) {
                return stateValue;
            }
            var _event = actions_1.initEvent;
            return new State({
                value: stateValue.value,
                context: context,
                _event: _event,
                _sessionid: null,
                historyValue: stateValue.historyValue,
                history: stateValue.history,
                activities: stateValue.activities,
                configuration: stateValue.configuration,
                transitions: [],
                children: {}
            });
        }
        return State.from(stateValue, context);
    };
    /**
     * Returns an array of all the string leaf state node paths.
     * @param stateValue
     * @param delimiter The character(s) that separate each subpath in the string state node path.
     */
    State.prototype.toStrings = function (stateValue, delimiter) {
        var _this = this;
        if (stateValue === void 0) { stateValue = this.value; }
        if (delimiter === void 0) { delimiter = '.'; }
        if (utils_1.isString(stateValue)) {
            return [stateValue];
        }
        var valueKeys = utils_1.keys(stateValue);
        return valueKeys.concat.apply(valueKeys, __spreadArray([], __read(valueKeys.map(function (key) {
            return _this.toStrings(stateValue[key], delimiter).map(function (s) { return key + delimiter + s; });
        }))));
    };
    State.prototype.toJSON = function () {
        var _a = this, configuration = _a.configuration, transitions = _a.transitions, tags = _a.tags, jsonValues = __rest(_a, ["configuration", "transitions", "tags"]);
        return __assign(__assign({}, jsonValues), { tags: Array.from(tags) });
    };
    /**
     * Whether the current state value is a subset of the given parent state value.
     * @param parentStateValue
     */
    State.prototype.matches = function (parentStateValue) {
        return utils_1.matchesState(parentStateValue, this.value);
    };
    /**
     * Whether the current state configuration has a state node with the specified `tag`.
     * @param tag
     */
    State.prototype.hasTag = function (tag) {
        return this.tags.has(tag);
    };
    return State;
}());
exports.State = State;
