import type { AssignAction, Assigner, PropertyAssigner, ExtractEvent, EventObject } from './types';
declare type AnyFunction = (...args: any[]) => any;
declare type Cast<A1 extends any, A2 extends any> = A1 extends A2 ? A1 : A2;
declare type Compute<A extends any> = {
    [K in keyof A]: A[K];
} & unknown;
declare type Prop<T, K> = K extends keyof T ? T[K] : never;
export interface Model<TContext, TEvent extends EventObject, TModelCreators = void> {
    initialContext: TContext;
    assign: <TEventType extends TEvent['type'] = TEvent['type']>(assigner: Assigner<TContext, ExtractEvent<TEvent, TEventType>> | PropertyAssigner<TContext, ExtractEvent<TEvent, TEventType>>, eventType?: TEventType) => AssignAction<TContext, ExtractEvent<TEvent, TEventType>>;
    events: Prop<TModelCreators, 'events'>;
    reset: () => AssignAction<TContext, any>;
}
export declare type ModelContextFrom<TModel extends Model<any, any, any>> = TModel extends Model<infer TContext, any, any> ? TContext : never;
export declare type ModelEventsFrom<TModel extends Model<any, any, any>> = TModel extends Model<any, infer TEvent, any> ? TEvent : never;
declare type EventCreator<Self extends AnyFunction, Return = ReturnType<Self>> = Return extends object ? Return extends {
    type: any;
} ? "An event creator can't return an object with a type property" : Self : 'An event creator must return an object';
declare type EventCreators<Self> = {
    [K in keyof Self]: Self[K] extends AnyFunction ? EventCreator<Self[K]> : 'An event creator must be a function';
};
declare type ModelCreators<Self> = {
    events: EventCreators<Prop<Self, 'events'>>;
};
declare type FinalEventCreators<Self> = {
    [K in keyof Self]: Self[K] extends AnyFunction ? (...args: Parameters<Self[K]>) => Compute<ReturnType<Self[K]> & {
        type: K;
    }> : never;
};
declare type FinalModelCreators<Self> = {
    events: FinalEventCreators<Prop<Self, 'events'>>;
};
declare type EventFromEventCreators<EventCreators> = {
    [K in keyof EventCreators]: EventCreators[K] extends AnyFunction ? ReturnType<EventCreators[K]> : never;
}[keyof EventCreators];
export declare function createModel<TContext, TEvent extends EventObject>(initialContext: TContext): Model<TContext, TEvent, void>;
export declare function createModel<TContext, TModelCreators extends ModelCreators<TModelCreators>, TFinalModelCreators = FinalModelCreators<TModelCreators>>(initialContext: TContext, creators: TModelCreators): Model<TContext, Cast<EventFromEventCreators<Prop<TFinalModelCreators, 'events'>>, EventObject>, TFinalModelCreators>;
export {};
//# sourceMappingURL=model.d.ts.map