import { EventObject, StateNode, StateValue } from '.';
declare type Configuration<TC, TE extends EventObject> = Iterable<StateNode<TC, any, TE>>;
declare type AdjList<TC, TE extends EventObject> = Map<StateNode<TC, any, TE>, Array<StateNode<TC, any, TE>>>;
export declare const isLeafNode: (stateNode: StateNode<any, any, any, any>) => boolean;
export declare function getChildren<TC, TE extends EventObject>(stateNode: StateNode<TC, any, TE>): Array<StateNode<TC, any, TE>>;
export declare function getAllStateNodes<TC, TE extends EventObject>(stateNode: StateNode<TC, any, TE, any>): Array<StateNode<TC, any, TE, any>>;
export declare function getConfiguration<TC, TE extends EventObject>(prevStateNodes: Iterable<StateNode<TC, any, TE, any>>, stateNodes: Iterable<StateNode<TC, any, TE, any>>): Iterable<StateNode<TC, any, TE, any>>;
export declare function getAdjList<TC, TE extends EventObject>(configuration: Configuration<TC, TE>): AdjList<TC, TE>;
export declare function getValue<TC, TE extends EventObject>(rootNode: StateNode<TC, any, TE, any>, configuration: Configuration<TC, TE>): StateValue;
export declare function has<T>(iterable: Iterable<T>, item: T): boolean;
export declare function nextEvents<TC, TE extends EventObject>(configuration: Array<StateNode<TC, any, TE>>): Array<TE['type']>;
export declare function isInFinalState<TC, TE extends EventObject>(configuration: Array<StateNode<TC, any, TE, any>>, stateNode: StateNode<TC, any, TE, any>): boolean;
export {};
//# sourceMappingURL=stateUtils.d.ts.map