/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum SubsystemType {
    Audible = 1,
    Visual = 2
}
export declare enum SubsystemState {
    Off = 0,
    On = 255
}
export declare enum BarrierOperatorCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    SignalingCapabilitiesGet = 4,
    SignalingCapabilitiesReport = 5,
    EventSignalingSet = 6,
    EventSignalingGet = 7,
    EventSignalingReport = 8
}
/**
 * @publicAPI
 */
export declare enum BarrierState {
    Closed = 0,
    Closing = 252,
    Stopped = 253,
    Opening = 254,
    Open = 255
}
export declare class BarrierOperatorCCAPI extends CCAPI {
    supportsCommand(cmd: BarrierOperatorCommand): Maybe<boolean>;
    get(): Promise<Pick<BarrierOperatorCCReport, "currentState" | "position"> | undefined>;
    set(targetState: BarrierState.Open | BarrierState.Closed): Promise<void>;
    getSignalingCapabilities(): Promise<readonly SubsystemType[] | undefined>;
    getEventSignaling(subsystemType: SubsystemType): Promise<SubsystemState | undefined>;
    setEventSignaling(subsystemType: SubsystemType, subsystemState: SubsystemState): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class BarrierOperatorCC extends CommandClass {
    ccCommand: BarrierOperatorCommand;
    interview(complete?: boolean): Promise<void>;
}
interface BarrierOperatorCCSetOptions extends CCCommandOptions {
    targetState: BarrierState.Open | BarrierState.Closed;
}
export declare class BarrierOperatorCCSet extends BarrierOperatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BarrierOperatorCCSetOptions);
    targetState: BarrierState.Open | BarrierState.Closed;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BarrierOperatorCCReport extends BarrierOperatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly currentState: BarrierState | undefined;
    readonly position: number | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BarrierOperatorCCGet extends BarrierOperatorCC {
}
export declare class BarrierOperatorCCSignalingCapabilitiesReport extends BarrierOperatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedsubsystemTypes;
    get supportedSubsystemTypes(): readonly SubsystemType[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BarrierOperatorCCSignalingCapabilitiesGet extends BarrierOperatorCC {
}
interface BarrierOperatorCCEventSignalingSetOptions extends CCCommandOptions {
    subsystemType: SubsystemType;
    subsystemState: SubsystemState;
}
export declare class BarrierOperatorCCEventSignalingSet extends BarrierOperatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BarrierOperatorCCEventSignalingSetOptions);
    subsystemType: SubsystemType;
    subsystemState: SubsystemState;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BarrierOperatorCCEventSignalingReport extends BarrierOperatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly subsystemType: SubsystemType;
    readonly subsystemState: SubsystemState;
    toLogEntry(): MessageOrCCLogEntry;
}
interface BarrierOperatorCCEventSignalingGetOptions extends CCCommandOptions {
    subsystemType: SubsystemType;
}
export declare class BarrierOperatorCCEventSignalingGet extends BarrierOperatorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | BarrierOperatorCCEventSignalingGetOptions);
    subsystemType: SubsystemType;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
