"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BarrierOperatorCCEventSignalingGet = exports.BarrierOperatorCCEventSignalingReport = exports.BarrierOperatorCCEventSignalingSet = exports.BarrierOperatorCCSignalingCapabilitiesGet = exports.BarrierOperatorCCSignalingCapabilitiesReport = exports.BarrierOperatorCCGet = exports.BarrierOperatorCCReport = exports.BarrierOperatorCCSet = exports.BarrierOperatorCC = exports.BarrierOperatorCCAPI = exports.BarrierState = exports.BarrierOperatorCommand = exports.SubsystemState = exports.SubsystemType = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// @publicAPI
var SubsystemType;
(function (SubsystemType) {
    SubsystemType[SubsystemType["Audible"] = 1] = "Audible";
    SubsystemType[SubsystemType["Visual"] = 2] = "Visual";
})(SubsystemType = exports.SubsystemType || (exports.SubsystemType = {}));
// @publicAPI
var SubsystemState;
(function (SubsystemState) {
    SubsystemState[SubsystemState["Off"] = 0] = "Off";
    SubsystemState[SubsystemState["On"] = 255] = "On";
})(SubsystemState = exports.SubsystemState || (exports.SubsystemState = {}));
function getSignalingStateValueId(endpoint, subsystemType) {
    return {
        commandClass: core_1.CommandClasses["Barrier Operator"],
        endpoint,
        property: "signalingState",
        propertyKey: subsystemType,
    };
}
function getSignalingStateMetadata(subsystemType) {
    return {
        ...core_1.ValueMetadata.UInt8,
        label: `Signaling State (${shared_1.getEnumMemberName(SubsystemType, subsystemType)})`,
        states: core_1.enumValuesToMetadataStates(SubsystemState),
    };
}
function getSupportedSubsystemTypesValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Barrier Operator"],
        endpoint,
        property: "supportedSubsystemTypes",
    };
}
function getTargetStateValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Barrier Operator"],
        endpoint,
        property: "targetState",
    };
}
// All the supported commands
var BarrierOperatorCommand;
(function (BarrierOperatorCommand) {
    BarrierOperatorCommand[BarrierOperatorCommand["Set"] = 1] = "Set";
    BarrierOperatorCommand[BarrierOperatorCommand["Get"] = 2] = "Get";
    BarrierOperatorCommand[BarrierOperatorCommand["Report"] = 3] = "Report";
    BarrierOperatorCommand[BarrierOperatorCommand["SignalingCapabilitiesGet"] = 4] = "SignalingCapabilitiesGet";
    BarrierOperatorCommand[BarrierOperatorCommand["SignalingCapabilitiesReport"] = 5] = "SignalingCapabilitiesReport";
    BarrierOperatorCommand[BarrierOperatorCommand["EventSignalingSet"] = 6] = "EventSignalingSet";
    BarrierOperatorCommand[BarrierOperatorCommand["EventSignalingGet"] = 7] = "EventSignalingGet";
    BarrierOperatorCommand[BarrierOperatorCommand["EventSignalingReport"] = 8] = "EventSignalingReport";
})(BarrierOperatorCommand = exports.BarrierOperatorCommand || (exports.BarrierOperatorCommand = {}));
/**
 * @publicAPI
 */
var BarrierState;
(function (BarrierState) {
    BarrierState[BarrierState["Closed"] = 0] = "Closed";
    BarrierState[BarrierState["Closing"] = 252] = "Closing";
    BarrierState[BarrierState["Stopped"] = 253] = "Stopped";
    BarrierState[BarrierState["Opening"] = 254] = "Opening";
    BarrierState[BarrierState["Open"] = 255] = "Open";
})(BarrierState = exports.BarrierState || (exports.BarrierState = {}));
let BarrierOperatorCCAPI = class BarrierOperatorCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            if (property === "targetState") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                const targetValue = value === BarrierState.Closed
                    ? BarrierState.Closed
                    : BarrierState.Open;
                await this.set(targetValue);
                // Verify the change after a delay
                if (this.isSinglecast()) {
                    this.schedulePoll({ property });
                }
            }
            else if (property === "signalingState") {
                if (propertyKey == undefined) {
                    API_1.throwMissingPropertyKey(this.ccId, property);
                }
                else if (typeof propertyKey !== "number") {
                    API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                }
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.setEventSignaling(propertyKey, value);
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, propertyKey, }) => {
            var _c;
            switch (property) {
                case "currentState":
                case "position":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                case "signalingState":
                    if (propertyKey == undefined) {
                        API_1.throwMissingPropertyKey(this.ccId, property);
                    }
                    else if (typeof propertyKey !== "number") {
                        API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                    }
                    return this.getEventSignaling(propertyKey);
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case BarrierOperatorCommand.Get:
            case BarrierOperatorCommand.Set:
            case BarrierOperatorCommand.SignalingCapabilitiesGet:
            case BarrierOperatorCommand.EventSignalingGet:
            case BarrierOperatorCommand.EventSignalingSet:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(BarrierOperatorCommand, BarrierOperatorCommand.Get);
        const cc = new BarrierOperatorCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["currentState", "position"]);
        }
    }
    async set(targetState) {
        this.assertSupportsCommand(BarrierOperatorCommand, BarrierOperatorCommand.Set);
        const cc = new BarrierOperatorCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            targetState,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getSignalingCapabilities() {
        this.assertSupportsCommand(BarrierOperatorCommand, BarrierOperatorCommand.SignalingCapabilitiesGet);
        const cc = new BarrierOperatorCCSignalingCapabilitiesGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedSubsystemTypes;
    }
    async getEventSignaling(subsystemType) {
        this.assertSupportsCommand(BarrierOperatorCommand, BarrierOperatorCommand.EventSignalingGet);
        const cc = new BarrierOperatorCCEventSignalingGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            subsystemType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.subsystemState;
    }
    async setEventSignaling(subsystemType, subsystemState) {
        this.assertSupportsCommand(BarrierOperatorCommand, BarrierOperatorCommand.EventSignalingSet);
        const cc = new BarrierOperatorCCEventSignalingSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            subsystemType,
            subsystemState,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
BarrierOperatorCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Barrier Operator"])
], BarrierOperatorCCAPI);
exports.BarrierOperatorCCAPI = BarrierOperatorCCAPI;
let BarrierOperatorCC = class BarrierOperatorCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _c;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Barrier Operator"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Create targetState value if it does not exist
        const targetStateValueID = getTargetStateValueId(this.endpointIndex);
        if (!node.valueDB.hasMetadata(targetStateValueID)) {
            node.valueDB.setMetadata(targetStateValueID, {
                ...core_1.ValueMetadata.UInt8,
                label: "Target Barrier State",
                states: core_1.enumValuesToMetadataStates(BarrierState, [
                    BarrierState.Open,
                    BarrierState.Closed,
                ]),
            });
        }
        let supportedSubsystems;
        if (complete) {
            this.driver.controllerLog.logNode(node.id, {
                message: "querying signaling capabilities...",
                direction: "outbound",
            });
            const resp = await api.getSignalingCapabilities();
            supportedSubsystems = resp !== null && resp !== void 0 ? resp : [];
            if (resp) {
                this.driver.controllerLog.logNode(node.id, {
                    message: `received supported subsystem types: ${resp
                        .map((t) => `\n· ${shared_1.getEnumMemberName(SubsystemType, t)}`)
                        .join("")}`,
                    direction: "inbound",
                });
            }
        }
        else {
            supportedSubsystems =
                (_c = node.getValue(getSupportedSubsystemTypesValueId(this.endpointIndex))) !== null && _c !== void 0 ? _c : [];
        }
        for (const subsystemType of supportedSubsystems) {
            this.driver.controllerLog.logNode(node.id, {
                message: `querying event signaling state for subsystem ${shared_1.getEnumMemberName(SubsystemType, subsystemType)}...`,
                direction: "outbound",
            });
            const state = await api.getEventSignaling(subsystemType);
            if (state != undefined) {
                this.driver.controllerLog.logNode(node.id, {
                    message: `subsystem ${shared_1.getEnumMemberName(SubsystemType, subsystemType)} has state ${shared_1.getEnumMemberName(SubsystemState, state)}`,
                    direction: "inbound",
                });
            }
        }
        this.driver.controllerLog.logNode(node.id, {
            message: "querying current barrier state...",
            direction: "outbound",
        });
        await api.get();
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
BarrierOperatorCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Barrier Operator"]),
    CommandClass_1.implementedVersion(1)
], BarrierOperatorCC);
exports.BarrierOperatorCC = BarrierOperatorCC;
let BarrierOperatorCCSet = class BarrierOperatorCCSet extends BarrierOperatorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.targetState = options.targetState;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.targetState]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "target state": this.targetState },
        };
    }
};
BarrierOperatorCCSet = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.Set)
], BarrierOperatorCCSet);
exports.BarrierOperatorCCSet = BarrierOperatorCCSet;
let BarrierOperatorCCReport = class BarrierOperatorCCReport extends BarrierOperatorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        // return values state and position value
        // if state is 0 - 99 or FF (100%) return the appropriate values.
        // if state is different just use the table and
        // return undefined position
        const payloadValue = this.payload[0];
        this.currentState = payloadValue;
        this.position = undefined;
        if (payloadValue <= 99) {
            this.position = payloadValue;
            if (payloadValue > 0) {
                this.currentState = undefined;
            }
        }
        else if (payloadValue === 255) {
            this.position = 100;
            this.currentState = payloadValue;
        }
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "barrier position": this.position,
                "barrier state": this.currentState != undefined
                    ? shared_1.getEnumMemberName(BarrierState, this.currentState)
                    : "unknown",
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Current Barrier State",
        states: core_1.enumValuesToMetadataStates(BarrierState),
    })
], BarrierOperatorCCReport.prototype, "currentState", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Barrier Position",
        unit: "%",
        max: 100,
    })
], BarrierOperatorCCReport.prototype, "position", void 0);
BarrierOperatorCCReport = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.Report)
], BarrierOperatorCCReport);
exports.BarrierOperatorCCReport = BarrierOperatorCCReport;
let BarrierOperatorCCGet = class BarrierOperatorCCGet extends BarrierOperatorCC {
};
BarrierOperatorCCGet = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.Get),
    CommandClass_1.expectedCCResponse(BarrierOperatorCCReport)
], BarrierOperatorCCGet);
exports.BarrierOperatorCCGet = BarrierOperatorCCGet;
let BarrierOperatorCCSignalingCapabilitiesReport = class BarrierOperatorCCSignalingCapabilitiesReport extends BarrierOperatorCC {
    constructor(driver, options) {
        super(driver, options);
        this._supportedsubsystemTypes = core_1.parseBitMask(this.payload, SubsystemType.Audible);
        this.persistValues();
    }
    get supportedSubsystemTypes() {
        return this._supportedsubsystemTypes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported types": this.supportedSubsystemTypes
                    .map((t) => `\n· ${shared_1.getEnumMemberName(SubsystemType, t)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], BarrierOperatorCCSignalingCapabilitiesReport.prototype, "supportedSubsystemTypes", null);
BarrierOperatorCCSignalingCapabilitiesReport = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.SignalingCapabilitiesReport)
], BarrierOperatorCCSignalingCapabilitiesReport);
exports.BarrierOperatorCCSignalingCapabilitiesReport = BarrierOperatorCCSignalingCapabilitiesReport;
let BarrierOperatorCCSignalingCapabilitiesGet = class BarrierOperatorCCSignalingCapabilitiesGet extends BarrierOperatorCC {
};
BarrierOperatorCCSignalingCapabilitiesGet = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.SignalingCapabilitiesGet),
    CommandClass_1.expectedCCResponse(BarrierOperatorCCSignalingCapabilitiesReport)
], BarrierOperatorCCSignalingCapabilitiesGet);
exports.BarrierOperatorCCSignalingCapabilitiesGet = BarrierOperatorCCSignalingCapabilitiesGet;
let BarrierOperatorCCEventSignalingSet = class BarrierOperatorCCEventSignalingSet extends BarrierOperatorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.subsystemType = options.subsystemType;
            this.subsystemState = options.subsystemState;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.subsystemType, this.subsystemState]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "subsystem type": shared_1.getEnumMemberName(SubsystemType, this.subsystemType),
                "subsystem state": shared_1.getEnumMemberName(SubsystemState, this.subsystemState),
            },
        };
    }
};
BarrierOperatorCCEventSignalingSet = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.EventSignalingSet)
], BarrierOperatorCCEventSignalingSet);
exports.BarrierOperatorCCEventSignalingSet = BarrierOperatorCCEventSignalingSet;
let BarrierOperatorCCEventSignalingReport = class BarrierOperatorCCEventSignalingReport extends BarrierOperatorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.subsystemType = this.payload[0];
        this.subsystemState = this.payload[1];
        this.persistValues();
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        const valueId = getSignalingStateValueId(this.endpointIndex, this.subsystemType);
        const valueDB = this.getValueDB();
        // Create metadata if it does not exist
        if (!valueDB.hasMetadata(valueId)) {
            valueDB.setMetadata(valueId, getSignalingStateMetadata(this.subsystemType));
        }
        valueDB.setValue(valueId, this.subsystemState);
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "subsystem type": shared_1.getEnumMemberName(SubsystemType, this.subsystemType),
                "subsystem state": shared_1.getEnumMemberName(SubsystemState, this.subsystemState),
            },
        };
    }
};
BarrierOperatorCCEventSignalingReport = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.EventSignalingReport)
], BarrierOperatorCCEventSignalingReport);
exports.BarrierOperatorCCEventSignalingReport = BarrierOperatorCCEventSignalingReport;
let BarrierOperatorCCEventSignalingGet = class BarrierOperatorCCEventSignalingGet extends BarrierOperatorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.subsystemType = options.subsystemType;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.subsystemType]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "subsystem type": shared_1.getEnumMemberName(SubsystemType, this.subsystemType),
            },
        };
    }
};
BarrierOperatorCCEventSignalingGet = __decorate([
    CommandClass_1.CCCommand(BarrierOperatorCommand.EventSignalingGet),
    CommandClass_1.expectedCCResponse(BarrierOperatorCCEventSignalingReport)
], BarrierOperatorCCEventSignalingGet);
exports.BarrierOperatorCCEventSignalingGet = BarrierOperatorCCEventSignalingGet;

//# sourceMappingURL=BarrierOperatorCC.js.map
