"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndicatorCCSupportedGet = exports.IndicatorCCSupportedReport = exports.IndicatorCCGet = exports.IndicatorCCReport = exports.IndicatorCCSet = exports.IndicatorCC = exports.IndicatorCCAPI = exports.IndicatorCommand = exports.getIndicatorValueValueID = exports.getSupportedPropertyIDsValueID = exports.getSupportedIndicatorIDsValueID = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
function getSupportedIndicatorIDsValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Indicator,
        endpoint,
        property: "supportedIndicatorIds",
    };
}
exports.getSupportedIndicatorIDsValueID = getSupportedIndicatorIDsValueID;
function getSupportedPropertyIDsValueID(endpoint, indicatorId) {
    return {
        commandClass: core_1.CommandClasses.Indicator,
        endpoint,
        property: "supportedPropertyIDs",
        propertyKey: indicatorId,
    };
}
exports.getSupportedPropertyIDsValueID = getSupportedPropertyIDsValueID;
function getIndicatorValueValueID(endpoint, indicatorId, propertyId) {
    if (indicatorId === 0) {
        // V1
        return {
            commandClass: core_1.CommandClasses.Indicator,
            endpoint,
            property: "value",
        };
    }
    else {
        // V2+
        return {
            commandClass: core_1.CommandClasses.Indicator,
            endpoint,
            property: indicatorId,
            propertyKey: propertyId,
        };
    }
}
exports.getIndicatorValueValueID = getIndicatorValueValueID;
/**
 * Looks up the configured metadata for the given indicator and property
 */
function getIndicatorMetadata(configManager, indicatorId, propertyId) {
    const label = configManager.lookupIndicator(indicatorId);
    const prop = configManager.lookupProperty(propertyId);
    if (!label && !prop) {
        return {
            ...core_1.ValueMetadata.UInt8,
            ccSpecific: {
                indicatorId,
                propertyId,
            },
        };
    }
    else if (!prop) {
        return {
            ...core_1.ValueMetadata.UInt8,
            label,
            ccSpecific: {
                indicatorId,
                propertyId,
            },
        };
    }
    else {
        if (prop.type === "boolean") {
            return {
                ...core_1.ValueMetadata.Boolean,
                label: `${label} - ${prop.label}`,
                description: prop.description,
                readable: !prop.readonly,
                ccSpecific: {
                    indicatorId,
                    propertyId,
                },
            };
        }
        else {
            // UInt8
            return {
                ...core_1.ValueMetadata.UInt8,
                label: `${label} - ${prop.label}`,
                description: prop.description,
                min: prop.min,
                max: prop.max,
                readable: !prop.readonly,
                ccSpecific: {
                    indicatorId,
                    propertyId,
                },
            };
        }
    }
}
function getIndicatorName(configManager, indicatorId) {
    var _c;
    let indicatorName = "0 (default)";
    if (indicatorId) {
        indicatorName = `${shared_1.num2hex(indicatorId)} (${(_c = configManager.lookupIndicator(indicatorId)) !== null && _c !== void 0 ? _c : `Unknown`})`;
    }
    return indicatorName;
}
// All the supported commands
var IndicatorCommand;
(function (IndicatorCommand) {
    IndicatorCommand[IndicatorCommand["Set"] = 1] = "Set";
    IndicatorCommand[IndicatorCommand["Get"] = 2] = "Get";
    IndicatorCommand[IndicatorCommand["Report"] = 3] = "Report";
    IndicatorCommand[IndicatorCommand["SupportedGet"] = 4] = "SupportedGet";
    IndicatorCommand[IndicatorCommand["SupportedReport"] = 5] = "SupportedReport";
})(IndicatorCommand = exports.IndicatorCommand || (exports.IndicatorCommand = {}));
const MAX_INDICATOR_OBJECTS = 31;
let IndicatorCCAPI = class IndicatorCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            if (property === "value") {
                // V1 value
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.set(value);
            }
            else if (typeof property === "number" &&
                typeof propertyKey === "number") {
                const indicatorId = property;
                const propertyId = propertyKey;
                const expectedType = getIndicatorMetadata(this.driver.configManager, indicatorId, propertyId).type;
                // V2+ value
                if (typeof value !== expectedType) {
                    API_1.throwWrongValueType(this.ccId, property, expectedType, typeof value);
                }
                await this.set([
                    {
                        indicatorId: property,
                        propertyId: propertyKey,
                        value: value,
                    },
                ]);
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, }) => {
            if (property === "value")
                return this.get();
            if (typeof property === "number") {
                return this.get(property);
            }
            API_1.throwUnsupportedProperty(this.ccId, property);
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case IndicatorCommand.Get:
                return this.isSinglecast();
            case IndicatorCommand.Set:
                return true; // This is mandatory
            case IndicatorCommand.SupportedGet:
                return this.version >= 2 && this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    async get(indicatorId) {
        this.assertSupportsCommand(IndicatorCommand, IndicatorCommand.Get);
        const cc = new IndicatorCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            indicatorId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (!response)
            return;
        if (response.values)
            return response.values;
        return response.value;
    }
    async set(value) {
        this.assertSupportsCommand(IndicatorCommand, IndicatorCommand.Set);
        const cc = new IndicatorCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            ...(typeof value === "number" ? { value } : { values: value }),
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getSupported(indicatorId) {
        this.assertSupportsCommand(IndicatorCommand, IndicatorCommand.SupportedGet);
        const cc = new IndicatorCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            indicatorId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return {
                // Include the actual indicator ID if 0x00 was requested
                ...(indicatorId === 0x00
                    ? { indicatorId: response.indicatorId }
                    : undefined),
                supportedProperties: response.supportedProperties,
                nextIndicatorId: response.nextIndicatorId,
            };
        }
    }
    /**
     * Instructs the node to identify itself. Available starting with V3 of this CC.
     */
    async identify() {
        if (this.version <= 3) {
            throw new core_1.ZWaveError(`The identify command is only supported in Version 3 and above`, core_1.ZWaveErrorCodes.CC_NotSupported);
        }
        await this.set([
            {
                indicatorId: 0x50,
                propertyId: 0x03,
                value: 0x08,
            },
            {
                indicatorId: 0x50,
                propertyId: 0x04,
                value: 0x03,
            },
            {
                indicatorId: 0x50,
                propertyId: 0x05,
                value: 0x06,
            },
        ]);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
IndicatorCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Indicator)
], IndicatorCCAPI);
exports.IndicatorCCAPI = IndicatorCCAPI;
let IndicatorCC = class IndicatorCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        this.registerValue(getSupportedIndicatorIDsValueID(undefined).property, true);
        this.registerValue(getSupportedPropertyIDsValueID(undefined, 0).property, true);
    }
    async interview(complete = true) {
        var _c, _d;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Indicator.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (this.version === 1) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "requesting current indicator value...",
                direction: "outbound",
            });
            await api.get();
        }
        else {
            let supportedIndicatorIds;
            if (complete) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "scanning supported indicator IDs...",
                    direction: "outbound",
                });
                // Query ID 0 to get the first supported ID
                let curId = 0x00;
                supportedIndicatorIds = [];
                do {
                    const supportedResponse = await api.getSupported(curId);
                    if (!supportedResponse) {
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: "Time out while scanning supported indicator IDs, skipping interview...",
                            level: "warn",
                        });
                        return;
                    }
                    supportedIndicatorIds.push((_c = supportedResponse.indicatorId) !== null && _c !== void 0 ? _c : curId);
                    curId = supportedResponse.nextIndicatorId;
                } while (curId !== 0x00);
                // The IDs are not stored by the report CCs so store them here once we have all of them
                this.getValueDB().setValue(getSupportedIndicatorIDsValueID(this.endpointIndex), supportedIndicatorIds);
                const logMessage = `supported indicator IDs: ${supportedIndicatorIds.join(", ")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                supportedIndicatorIds =
                    (_d = this.getValueDB().getValue(getSupportedIndicatorIDsValueID(this.endpointIndex))) !== null && _d !== void 0 ? _d : [];
            }
            for (const indicatorId of supportedIndicatorIds) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `requesting current indicator value (id = ${shared_1.num2hex(indicatorId)})...`,
                    direction: "outbound",
                });
                await api.get(indicatorId);
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    translatePropertyKey(property, propertyKey) {
        if (property === "value") {
            // CC version 1 only has a single value that doesn't need to be translated
            return undefined;
        }
        else if (typeof property === "number" &&
            typeof propertyKey === "number") {
            // The indicator property is our property key
            const prop = this.driver.configManager.lookupProperty(propertyKey);
            if (prop)
                return prop.label;
        }
        return super.translatePropertyKey(property, propertyKey);
    }
    translateProperty(property, propertyKey) {
        if (typeof property === "number" && typeof propertyKey === "number") {
            // The indicator corresponds to our property
            const label = this.driver.configManager.lookupIndicator(property);
            if (label)
                return label;
        }
        return super.translateProperty(property, propertyKey);
    }
    supportsV2Indicators() {
        // First test if there are any indicator ids defined
        const supportedIndicatorIds = this.getValueDB().getValue(getSupportedIndicatorIDsValueID(this.endpointIndex));
        if (!(supportedIndicatorIds === null || supportedIndicatorIds === void 0 ? void 0 : supportedIndicatorIds.length))
            return false;
        // Then test if there are any property ids defined
        return supportedIndicatorIds.some((indicatorId) => {
            var _c;
            return !!((_c = this.getValueDB().getValue(getSupportedPropertyIDsValueID(this.endpointIndex, indicatorId))) === null || _c === void 0 ? void 0 : _c.length);
        });
    }
};
IndicatorCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Indicator),
    CommandClass_1.implementedVersion(3)
], IndicatorCC);
exports.IndicatorCC = IndicatorCC;
let IndicatorCCSet = class IndicatorCCSet extends IndicatorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (this.version === 1) {
                if (!("value" in options)) {
                    throw new core_1.ZWaveError(`Node ${this.nodeId} only supports IndicatorCC V1 which requires a single value to be set`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
                this.indicator0Value = options.value;
            }
            else {
                if ("value" in options) {
                    this.indicator0Value = options.value;
                }
                else {
                    if (options.values.length > MAX_INDICATOR_OBJECTS) {
                        throw new core_1.ZWaveError(`Only ${MAX_INDICATOR_OBJECTS} indicator values can be set at a time!`, core_1.ZWaveErrorCodes.Argument_Invalid);
                    }
                    this.values = options.values;
                }
            }
        }
    }
    serialize() {
        if (this.indicator0Value != undefined) {
            this.payload = Buffer.from([this.indicator0Value]);
        }
        else {
            const values = this.values;
            const objCount = values.length & MAX_INDICATOR_OBJECTS;
            const valuesFlat = values
                .slice(0, objCount + 1)
                .map((o) => [
                o.indicatorId,
                o.propertyId,
                typeof o.value === "number"
                    ? o.value
                    : o.value
                        ? 0xff
                        : 0x00,
            ])
                .reduce((acc, cur) => acc.concat(...cur), []);
            this.payload = Buffer.concat([
                Buffer.from([0, objCount]),
                Buffer.from(valuesFlat),
            ]);
        }
        return super.serialize();
    }
    toLogEntry() {
        const message = {};
        if (this.indicator0Value != undefined) {
            message["indicator 0 value"] = this.indicator0Value;
        }
        if (this.values != undefined) {
            message.values = `${this.values
                .map((v) => `
· indicatorId: ${v.indicatorId}
  propertyId:  ${v.propertyId}
  value:       ${v.value}`)
                .join("")}`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
IndicatorCCSet = __decorate([
    CommandClass_1.CCCommand(IndicatorCommand.Set)
], IndicatorCCSet);
exports.IndicatorCCSet = IndicatorCCSet;
let IndicatorCCReport = class IndicatorCCReport extends IndicatorCC {
    // @noCCValues This CC stores its values diffently
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        const valueDB = this.getValueDB();
        const objCount = this.payload.length >= 2 ? this.payload[1] & 0b11111 : 0;
        if (objCount === 0) {
            this.value = this.payload[0];
            if (!this.supportsV2Indicators()) {
                // Publish the value
                const valueId = getIndicatorValueValueID(this.endpointIndex, 0, 1);
                valueDB.setMetadata(valueId, {
                    ...core_1.ValueMetadata.UInt8,
                    label: "Indicator value",
                    ccSpecific: {
                        indicatorId: 0,
                    },
                });
                valueDB.setValue(valueId, this.value);
            }
            else {
                if (this.isSinglecast()) {
                    // Don't!
                    this.driver.controllerLog.logNode(this.nodeId, {
                        message: `ignoring V1 indicator report because the node supports V2 indicators`,
                        direction: "none",
                        endpoint: this.endpointIndex,
                    });
                }
            }
        }
        else {
            core_1.validatePayload(this.payload.length >= 2 + 3 * objCount);
            this.values = [];
            for (let i = 0; i < objCount; i++) {
                const offset = 2 + 3 * i;
                const value = {
                    indicatorId: this.payload[offset],
                    propertyId: this.payload[offset + 1],
                    value: this.payload[offset + 2],
                };
                this.setIndicatorValue(value);
            }
            // TODO: Think if we want this:
            // // If not all Property IDs are included in the command for the actual Indicator ID,
            // // a controlling node MUST assume non-specified Property IDs values to be 0x00.
            // const indicatorId = this.values[0].indicatorId;
            // const supportedIndicatorProperties =
            // 	valueDB.getValue<number[]>(
            // 		getSupportedPropertyIDsValueID(
            // 			this.endpointIndex,
            // 			indicatorId,
            // 		),
            // 	) ?? [];
            // // Find out which ones are missing
            // const missingIndicatorProperties = supportedIndicatorProperties.filter(
            // 	prop =>
            // 		!this.values!.find(({ propertyId }) => prop === propertyId),
            // );
            // // And assume they are 0 (false)
            // for (const missing of missingIndicatorProperties) {
            // 	this.setIndicatorValue({
            // 		indicatorId,
            // 		propertyId: missing,
            // 		value: 0,
            // 	});
            // }
        }
    }
    setIndicatorValue(value) {
        const valueDB = this.getValueDB();
        const metadata = getIndicatorMetadata(this.driver.configManager, value.indicatorId, value.propertyId);
        // Some values need to be converted
        if (metadata.type === "boolean") {
            value.value = !!value.value;
        }
        this.values.push(value);
        // Publish the value
        const valueId = getIndicatorValueValueID(this.endpointIndex, value.indicatorId, value.propertyId);
        valueDB.setMetadata(valueId, metadata);
        valueDB.setValue(valueId, value.value);
    }
    toLogEntry() {
        const message = {};
        if (this.value != undefined) {
            message["indicator 0 value"] = this.value;
        }
        if (this.values != undefined) {
            message.values = `${this.values
                .map((v) => `
· indicatorId: ${v.indicatorId}
  propertyId:  ${v.propertyId}
  value:       ${v.value}`)
                .join("")}`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
IndicatorCCReport = __decorate([
    CommandClass_1.CCCommand(IndicatorCommand.Report)
], IndicatorCCReport);
exports.IndicatorCCReport = IndicatorCCReport;
let IndicatorCCGet = class IndicatorCCGet extends IndicatorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.indicatorId = options.indicatorId;
        }
    }
    serialize() {
        if (this.indicatorId != undefined) {
            this.payload = Buffer.from([this.indicatorId]);
        }
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                indicator: getIndicatorName(this.driver.configManager, this.indicatorId),
            },
        };
    }
};
IndicatorCCGet = __decorate([
    CommandClass_1.CCCommand(IndicatorCommand.Get),
    CommandClass_1.expectedCCResponse(IndicatorCCReport)
], IndicatorCCGet);
exports.IndicatorCCGet = IndicatorCCGet;
let IndicatorCCSupportedReport = class IndicatorCCSupportedReport extends IndicatorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this.indicatorId = this.payload[0];
        this.nextIndicatorId = this.payload[1];
        const bitMaskLength = this.payload[2] & 0b11111;
        if (bitMaskLength === 0) {
            this.supportedProperties = [];
        }
        else {
            core_1.validatePayload(this.payload.length >= 3 + bitMaskLength);
            // The bit mask starts at 0, but bit 0 is not used
            this.supportedProperties = core_1.parseBitMask(this.payload.slice(3, 3 + bitMaskLength), 0).filter((v) => v !== 0);
        }
        this.persistValues();
    }
    persistValues() {
        if (this.indicatorId !== 0x00) {
            // Remember which property IDs are supported
            this.getValueDB().setValue(getSupportedPropertyIDsValueID(this.endpointIndex, this.indicatorId), this.supportedProperties);
        }
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                indicator: getIndicatorName(this.driver.configManager, this.indicatorId),
                "supported properties": `${this.supportedProperties
                    .map((id) => {
                    var _c, _d;
                    return (_d = (_c = this.driver.configManager.lookupProperty(id)) === null || _c === void 0 ? void 0 : _c.label) !== null && _d !== void 0 ? _d : `Unknown (${shared_1.num2hex(id)})`;
                })
                    .join(", ")}`,
                "next indicator": getIndicatorName(this.driver.configManager, this.nextIndicatorId),
            },
        };
    }
};
IndicatorCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(IndicatorCommand.SupportedReport)
], IndicatorCCSupportedReport);
exports.IndicatorCCSupportedReport = IndicatorCCSupportedReport;
let IndicatorCCSupportedGet = class IndicatorCCSupportedGet extends IndicatorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.indicatorId = options.indicatorId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.indicatorId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                indicator: getIndicatorName(this.driver.configManager, this.indicatorId),
            },
        };
    }
};
IndicatorCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(IndicatorCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(IndicatorCCSupportedReport)
], IndicatorCCSupportedGet);
exports.IndicatorCCSupportedGet = IndicatorCCSupportedGet;

//# sourceMappingURL=IndicatorCC.js.map
