/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum LanguageCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare class LanguageCCAPI extends CCAPI {
    supportsCommand(cmd: LanguageCommand): Maybe<boolean>;
    get(): Promise<Pick<LanguageCCReport, "language" | "country"> | undefined>;
    set(language: string, country?: string): Promise<void>;
}
export declare class LanguageCC extends CommandClass {
    ccCommand: LanguageCommand;
    interview(complete?: boolean): Promise<void>;
}
interface LanguageCCSetOptions extends CCCommandOptions {
    language: string;
    country?: string;
}
export declare class LanguageCCSet extends LanguageCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | LanguageCCSetOptions);
    private _language;
    get language(): string;
    set language(value: string);
    private _country;
    get country(): string | undefined;
    set country(value: string | undefined);
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class LanguageCCReport extends LanguageCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly language: string;
    readonly country: string | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class LanguageCCGet extends LanguageCC {
}
export {};
