"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LanguageCCGet = exports.LanguageCCReport = exports.LanguageCCSet = exports.LanguageCC = exports.LanguageCCAPI = exports.LanguageCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var LanguageCommand;
(function (LanguageCommand) {
    LanguageCommand[LanguageCommand["Set"] = 1] = "Set";
    LanguageCommand[LanguageCommand["Get"] = 2] = "Get";
    LanguageCommand[LanguageCommand["Report"] = 3] = "Report";
})(LanguageCommand = exports.LanguageCommand || (exports.LanguageCommand = {}));
// @noSetValueAPI It doesn't make sense
let LanguageCCAPI = class LanguageCCAPI extends API_1.CCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case LanguageCommand.Get:
                return this.isSinglecast();
            case LanguageCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(LanguageCommand, LanguageCommand.Get);
        const cc = new LanguageCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["language", "country"]);
        }
    }
    async set(language, country) {
        this.assertSupportsCommand(LanguageCommand, LanguageCommand.Set);
        const cc = new LanguageCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            language,
            country,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
LanguageCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Language)
], LanguageCCAPI);
exports.LanguageCCAPI = LanguageCCAPI;
let LanguageCC = class LanguageCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Language.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "requesting language setting...",
            direction: "outbound",
        });
        const resp = await api.get();
        if (resp) {
            const { language, country } = resp;
            const logMessage = `received current language setting: ${language}${country != undefined ? `-${country}` : ""}`;
            this.driver.controllerLog.logNode(node.id, {
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
LanguageCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Language),
    CommandClass_1.implementedVersion(1)
], LanguageCC);
exports.LanguageCC = LanguageCC;
let LanguageCCSet = class LanguageCCSet extends LanguageCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            // Populate properties from options object
            this._language = options.language;
            this._country = options.country;
        }
    }
    get language() {
        return this._language;
    }
    set language(value) {
        if (value.length !== 3 || value.toLowerCase() !== value) {
            throw new core_1.ZWaveError("language must be a 3 digit (lowercase) code according to ISO 639-2", core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        this._language = value;
    }
    get country() {
        return this._country;
    }
    set country(value) {
        if (typeof value === "string" &&
            (value.length !== 2 || value.toUpperCase() !== value)) {
            throw new core_1.ZWaveError("country must be a 2 digit (uppercase) code according to ISO 3166-1", core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        this._country = value;
    }
    serialize() {
        this.payload = Buffer.allocUnsafe(!!this._country ? 5 : 3);
        this.payload.write(this._language, 0, "ascii");
        if (!!this._country)
            this.payload.write(this._country, 3, "ascii");
        return super.serialize();
    }
    toLogEntry() {
        const message = { language: this.language };
        if (this._country != undefined) {
            message.country = this._country;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
LanguageCCSet = __decorate([
    CommandClass_1.CCCommand(LanguageCommand.Set)
], LanguageCCSet);
exports.LanguageCCSet = LanguageCCSet;
let LanguageCCReport = class LanguageCCReport extends LanguageCC {
    constructor(driver, options) {
        super(driver, options);
        // if (gotDeserializationOptions(options)) {
        core_1.validatePayload(this.payload.length >= 3);
        this.language = this.payload.toString("ascii", 0, 3);
        if (this.payload.length >= 5) {
            this.country = this.payload.toString("ascii", 3, 5);
        }
        // }
        this.persistValues();
    }
    toLogEntry() {
        const message = { language: this.language };
        if (this.country != undefined) {
            message.country = this.country;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "Language code",
    })
], LanguageCCReport.prototype, "language", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnly,
        label: "Country code",
    })
], LanguageCCReport.prototype, "country", void 0);
LanguageCCReport = __decorate([
    CommandClass_1.CCCommand(LanguageCommand.Report)
], LanguageCCReport);
exports.LanguageCCReport = LanguageCCReport;
let LanguageCCGet = class LanguageCCGet extends LanguageCC {
};
LanguageCCGet = __decorate([
    CommandClass_1.CCCommand(LanguageCommand.Get),
    CommandClass_1.expectedCCResponse(LanguageCCReport)
], LanguageCCGet);
exports.LanguageCCGet = LanguageCCGet;

//# sourceMappingURL=LanguageCC.js.map
