/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { CommandClasses, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare function getManufacturerIdValueId(): ValueID;
export declare function getProductTypeValueId(): ValueID;
export declare function getProductIdValueId(): ValueID;
export declare function getManufacturerIdValueMetadata(): ValueMetadata;
export declare function getProductTypeValueMetadata(): ValueMetadata;
export declare function getProductIdValueMetadata(): ValueMetadata;
export declare enum ManufacturerSpecificCommand {
    Get = 4,
    Report = 5,
    DeviceSpecificGet = 6,
    DeviceSpecificReport = 7
}
/**
 * @publicAPI
 */
export declare enum DeviceIdType {
    FactoryDefault = 0,
    SerialNumber = 1,
    PseudoRandom = 2
}
export declare class ManufacturerSpecificCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: ManufacturerSpecificCommand): Maybe<boolean>;
    get(): Promise<Pick<ManufacturerSpecificCCReport, "manufacturerId" | "productType" | "productId"> | undefined>;
    deviceSpecificGet(deviceIdType: DeviceIdType): Promise<string | undefined>;
}
export declare class ManufacturerSpecificCC extends CommandClass {
    ccCommand: ManufacturerSpecificCommand;
    determineRequiredCCInterviews(): readonly CommandClasses[];
    interview(complete?: boolean): Promise<void>;
}
export declare class ManufacturerSpecificCCReport extends ManufacturerSpecificCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _manufacturerId;
    get manufacturerId(): number;
    private _productType;
    get productType(): number;
    private _productId;
    get productId(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ManufacturerSpecificCCGet extends ManufacturerSpecificCC {
}
export declare class ManufacturerSpecificCCDeviceSpecificReport extends ManufacturerSpecificCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly type: DeviceIdType;
    readonly deviceId: string;
    toLogEntry(): MessageOrCCLogEntry;
}
interface ManufacturerSpecificCCDeviceSpecificGetOptions extends CCCommandOptions {
    deviceIdType: DeviceIdType;
}
export declare class ManufacturerSpecificCCDeviceSpecificGet extends ManufacturerSpecificCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ManufacturerSpecificCCDeviceSpecificGetOptions);
    deviceIdType: DeviceIdType;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
