"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.messageIsPing = exports.NoOperationCC = exports.NoOperationCCAPI = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
const ICommandClassContainer_1 = require("./ICommandClassContainer");
// @noSetValueAPI This CC has no set-type commands
// @noInterview There's nothing to interview here
let NoOperationCCAPI = class NoOperationCCAPI extends API_1.PhysicalCCAPI {
    async send() {
        await this.driver.sendCommand(new NoOperationCC(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        }), {
            ...this.commandOptions,
            // Don't retry sending ping packets
            maxSendAttempts: 1,
            // Pings have their own dedicated priority, since they
            // are used to test whether a node is awake/alive
            priority: Constants_1.MessagePriority.Ping,
        });
    }
};
NoOperationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["No Operation"])
], NoOperationCCAPI);
exports.NoOperationCCAPI = NoOperationCCAPI;
let NoOperationCC = class NoOperationCC extends CommandClass_1.CommandClass {
};
NoOperationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["No Operation"]),
    CommandClass_1.implementedVersion(1)
], NoOperationCC);
exports.NoOperationCC = NoOperationCC;
/** Tests if a given message is a ping */
function messageIsPing(msg) {
    return ICommandClassContainer_1.isCommandClassContainer(msg) && msg.command instanceof NoOperationCC;
}
exports.messageIsPing = messageIsPing;

//# sourceMappingURL=NoOperationCC.js.map
