/// <reference types="node" />
import { Duration, Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum SceneActuatorConfigurationCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare function getLevelValueID(endpoint: number | undefined, sceneId: number): ValueID;
export declare function getDimmingDurationValueID(endpoint: number | undefined, sceneId: number): ValueID;
export declare class SceneActuatorConfigurationCCAPI extends CCAPI {
    supportsCommand(cmd: SceneActuatorConfigurationCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    set(sceneId: number, dimmingDuration: Duration, level?: number): Promise<void>;
    getActive(): Promise<Pick<SceneActuatorConfigurationCCReport, "sceneId" | "level" | "dimmingDuration"> | undefined>;
    get(sceneId: number): Promise<Pick<SceneActuatorConfigurationCCReport, "level" | "dimmingDuration"> | undefined>;
}
export declare class SceneActuatorConfigurationCC extends CommandClass {
    ccCommand: SceneActuatorConfigurationCommand;
}
interface SceneActuatorConfigurationCCSetOptions extends CCCommandOptions {
    sceneId: number;
    dimmingDuration: Duration;
    level?: number;
}
export declare class SceneActuatorConfigurationCCSet extends SceneActuatorConfigurationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SceneActuatorConfigurationCCSetOptions);
    sceneId: number;
    dimmingDuration: Duration;
    level?: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SceneActuatorConfigurationCCReport extends SceneActuatorConfigurationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly sceneId: number;
    readonly level?: number;
    readonly dimmingDuration?: Duration;
    persistValues(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
interface SceneActuatorConfigurationCCGetOptions extends CCCommandOptions {
    sceneId: number;
}
export declare class SceneActuatorConfigurationCCGet extends SceneActuatorConfigurationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SceneActuatorConfigurationCCGetOptions);
    sceneId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
