"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SceneActuatorConfigurationCCGet = exports.SceneActuatorConfigurationCCReport = exports.SceneActuatorConfigurationCCSet = exports.SceneActuatorConfigurationCC = exports.SceneActuatorConfigurationCCAPI = exports.getDimmingDurationValueID = exports.getLevelValueID = exports.SceneActuatorConfigurationCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var SceneActuatorConfigurationCommand;
(function (SceneActuatorConfigurationCommand) {
    SceneActuatorConfigurationCommand[SceneActuatorConfigurationCommand["Set"] = 1] = "Set";
    SceneActuatorConfigurationCommand[SceneActuatorConfigurationCommand["Get"] = 2] = "Get";
    SceneActuatorConfigurationCommand[SceneActuatorConfigurationCommand["Report"] = 3] = "Report";
})(SceneActuatorConfigurationCommand = exports.SceneActuatorConfigurationCommand || (exports.SceneActuatorConfigurationCommand = {}));
function getLevelValueID(endpoint, sceneId) {
    return {
        commandClass: core_1.CommandClasses["Scene Actuator Configuration"],
        endpoint,
        property: "level",
        propertyKey: sceneId,
    };
}
exports.getLevelValueID = getLevelValueID;
function getDimmingDurationValueID(endpoint, sceneId) {
    return {
        commandClass: core_1.CommandClasses["Scene Actuator Configuration"],
        endpoint,
        property: "dimmingDuration",
        propertyKey: sceneId,
    };
}
exports.getDimmingDurationValueID = getDimmingDurationValueID;
function persistSceneActuatorConfig(sceneId, level, dimmingDuration) {
    const levelValueId = getLevelValueID(this.endpointIndex, sceneId);
    const dimmingDurationValueId = getDimmingDurationValueID(this.endpointIndex, sceneId);
    const valueDB = this.getValueDB();
    if (!valueDB.hasMetadata(levelValueId)) {
        valueDB.setMetadata(levelValueId, {
            ...core_1.ValueMetadata.UInt8,
            label: `Level (${sceneId})`,
        });
    }
    if (!valueDB.hasMetadata(dimmingDurationValueId)) {
        valueDB.setMetadata(dimmingDurationValueId, {
            ...core_1.ValueMetadata.Duration,
            label: `Dimming duration (${sceneId})`,
        });
    }
    valueDB.setValue(levelValueId, level);
    valueDB.setValue(dimmingDurationValueId, dimmingDuration);
    return true;
}
let SceneActuatorConfigurationCCAPI = class SceneActuatorConfigurationCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            var _c;
            if (propertyKey == undefined) {
                API_1.throwMissingPropertyKey(this.ccId, property);
            }
            else if (typeof propertyKey !== "number") {
                API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
            }
            if (property === "level") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                // We need to set the dimming duration along with the level.
                // If no duration is set, we default to 0 seconds
                const node = this.endpoint.getNodeUnsafe();
                const dimmingDuration = (_c = node.getValue(getDimmingDurationValueID(this.endpoint.index, propertyKey))) !== null && _c !== void 0 ? _c : new core_1.Duration(0, "seconds");
                await this.set(propertyKey, dimmingDuration, value);
            }
            else {
                // setting dimmingDuration value alone not supported
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, propertyKey, }) => {
            var _c;
            switch (property) {
                case "level":
                case "dimmingDuration": {
                    if (propertyKey == undefined) {
                        API_1.throwMissingPropertyKey(this.ccId, property);
                    }
                    else if (typeof propertyKey !== "number") {
                        API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                    }
                    return (_c = (await this.get(propertyKey))) === null || _c === void 0 ? void 0 : _c[property];
                }
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case SceneActuatorConfigurationCommand.Get:
                return this.isSinglecast();
            case SceneActuatorConfigurationCommand.Set:
                return true;
        }
        return super.supportsCommand(cmd);
    }
    async set(sceneId, dimmingDuration, level) {
        this.assertSupportsCommand(SceneActuatorConfigurationCommand, SceneActuatorConfigurationCommand.Set);
        const cc = new SceneActuatorConfigurationCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sceneId,
            dimmingDuration,
            level,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getActive() {
        this.assertSupportsCommand(SceneActuatorConfigurationCommand, SceneActuatorConfigurationCommand.Get);
        const cc = new SceneActuatorConfigurationCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sceneId: 0,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["sceneId", "level", "dimmingDuration"]);
        }
    }
    async get(sceneId) {
        this.assertSupportsCommand(SceneActuatorConfigurationCommand, SceneActuatorConfigurationCommand.Get);
        if (sceneId === 0) {
            throw new core_1.ZWaveError(`Invalid scene ID 0. To get the currently active scene, use getActive() instead.`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        const cc = new SceneActuatorConfigurationCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sceneId: sceneId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["level", "dimmingDuration"]);
        }
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
SceneActuatorConfigurationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Scene Actuator Configuration"])
], SceneActuatorConfigurationCCAPI);
exports.SceneActuatorConfigurationCCAPI = SceneActuatorConfigurationCCAPI;
// @noInterview - We don't want to query 255 scenes
let SceneActuatorConfigurationCC = class SceneActuatorConfigurationCC extends CommandClass_1.CommandClass {
};
SceneActuatorConfigurationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Scene Actuator Configuration"]),
    CommandClass_1.implementedVersion(1)
], SceneActuatorConfigurationCC);
exports.SceneActuatorConfigurationCC = SceneActuatorConfigurationCC;
let SceneActuatorConfigurationCCSet = class SceneActuatorConfigurationCCSet extends SceneActuatorConfigurationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (options.sceneId < 1 || options.sceneId > 255) {
                throw new core_1.ZWaveError(`The scene id ${options.sceneId} must be between 1 and 255!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.sceneId = options.sceneId;
            this.dimmingDuration = options.dimmingDuration;
            this.level = options.level;
        }
    }
    serialize() {
        var _c;
        this.payload = Buffer.from([
            this.sceneId,
            this.dimmingDuration.serializeSet(),
            this.level != undefined ? 128 : 0,
            (_c = this.level) !== null && _c !== void 0 ? _c : 0xff,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        var _c;
        return {
            ...super.toLogEntry(),
            message: {
                sceneId: this.sceneId,
                level: this.level,
                dimmingDuration: (_c = this.dimmingDuration) === null || _c === void 0 ? void 0 : _c.toString(),
            },
        };
    }
};
SceneActuatorConfigurationCCSet = __decorate([
    CommandClass_1.CCCommand(SceneActuatorConfigurationCommand.Set)
], SceneActuatorConfigurationCCSet);
exports.SceneActuatorConfigurationCCSet = SceneActuatorConfigurationCCSet;
let SceneActuatorConfigurationCCReport = class SceneActuatorConfigurationCCReport extends SceneActuatorConfigurationCC {
    constructor(driver, options) {
        var _c;
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this.sceneId = this.payload[0];
        if (this.sceneId !== 0) {
            this.level = this.payload[1];
            this.dimmingDuration =
                (_c = core_1.Duration.parseReport(this.payload[2])) !== null && _c !== void 0 ? _c : new core_1.Duration(0, "unknown");
        }
        this.persistValues();
    }
    persistValues() {
        // Do not persist values for an inactive scene
        if (this.sceneId === 0 ||
            this.level == undefined ||
            this.dimmingDuration == undefined) {
            return false;
        }
        return persistSceneActuatorConfig.call(this, this.sceneId, this.level, this.dimmingDuration);
    }
    toLogEntry() {
        var _c;
        return {
            ...super.toLogEntry(),
            message: {
                sceneId: this.sceneId,
                level: this.level,
                dimmingDuration: (_c = this.dimmingDuration) === null || _c === void 0 ? void 0 : _c.toString(),
            },
        };
    }
};
SceneActuatorConfigurationCCReport = __decorate([
    CommandClass_1.CCCommand(SceneActuatorConfigurationCommand.Report)
], SceneActuatorConfigurationCCReport);
exports.SceneActuatorConfigurationCCReport = SceneActuatorConfigurationCCReport;
function testResponseForSceneActuatorConfigurationGet(sent, received) {
    // We expect a Scene Actuator Configuration Report that matches
    // the requested sceneId, unless groupId 0 was requested
    return sent.sceneId === 0 || received.sceneId === sent.sceneId;
}
let SceneActuatorConfigurationCCGet = class SceneActuatorConfigurationCCGet extends SceneActuatorConfigurationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.sceneId = options.sceneId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.sceneId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "scene id": this.sceneId },
        };
    }
};
SceneActuatorConfigurationCCGet = __decorate([
    CommandClass_1.CCCommand(SceneActuatorConfigurationCommand.Get),
    CommandClass_1.expectedCCResponse(SceneActuatorConfigurationCCReport, testResponseForSceneActuatorConfigurationGet)
], SceneActuatorConfigurationCCGet);
exports.SceneActuatorConfigurationCCGet = SceneActuatorConfigurationCCGet;

//# sourceMappingURL=SceneActuatorConfigurationCC.js.map
