"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThermostatFanModeCCSupportedGet = exports.ThermostatFanModeCCSupportedReport = exports.ThermostatFanModeCCGet = exports.ThermostatFanModeCCReport = exports.ThermostatFanModeCCSet = exports.ThermostatFanModeCC = exports.ThermostatFanModeCCAPI = exports.getModeStateValueID = exports.getOffStateValueID = exports.ThermostatFanMode = exports.ThermostatFanModeCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
const ThermostatModeCC_1 = require("./ThermostatModeCC");
// All the supported commands
var ThermostatFanModeCommand;
(function (ThermostatFanModeCommand) {
    ThermostatFanModeCommand[ThermostatFanModeCommand["Set"] = 1] = "Set";
    ThermostatFanModeCommand[ThermostatFanModeCommand["Get"] = 2] = "Get";
    ThermostatFanModeCommand[ThermostatFanModeCommand["Report"] = 3] = "Report";
    ThermostatFanModeCommand[ThermostatFanModeCommand["SupportedGet"] = 4] = "SupportedGet";
    ThermostatFanModeCommand[ThermostatFanModeCommand["SupportedReport"] = 5] = "SupportedReport";
})(ThermostatFanModeCommand = exports.ThermostatFanModeCommand || (exports.ThermostatFanModeCommand = {}));
/**
 * @publicAPI
 */
var ThermostatFanMode;
(function (ThermostatFanMode) {
    ThermostatFanMode[ThermostatFanMode["Auto low"] = 0] = "Auto low";
    ThermostatFanMode[ThermostatFanMode["Low"] = 1] = "Low";
    ThermostatFanMode[ThermostatFanMode["Auto high"] = 2] = "Auto high";
    ThermostatFanMode[ThermostatFanMode["High"] = 3] = "High";
    ThermostatFanMode[ThermostatFanMode["Auto medium"] = 4] = "Auto medium";
    ThermostatFanMode[ThermostatFanMode["Medium"] = 5] = "Medium";
    ThermostatFanMode[ThermostatFanMode["Circulation"] = 6] = "Circulation";
    ThermostatFanMode[ThermostatFanMode["Humidity circulation"] = 7] = "Humidity circulation";
    ThermostatFanMode[ThermostatFanMode["Left and right"] = 8] = "Left and right";
    ThermostatFanMode[ThermostatFanMode["Up and down"] = 9] = "Up and down";
    ThermostatFanMode[ThermostatFanMode["Quiet"] = 10] = "Quiet";
    ThermostatFanMode[ThermostatFanMode["External circulation"] = 11] = "External circulation";
})(ThermostatFanMode = exports.ThermostatFanMode || (exports.ThermostatFanMode = {}));
function getOffStateValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Thermostat Fan Mode"],
        endpoint,
        property: "off",
    };
}
exports.getOffStateValueID = getOffStateValueID;
function getModeStateValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Thermostat Fan Mode"],
        endpoint,
        property: "mode",
    };
}
exports.getModeStateValueID = getModeStateValueID;
let ThermostatFanModeCCAPI = class ThermostatFanModeCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            const valueDB = this.endpoint.getNodeUnsafe().valueDB;
            if (property === "mode") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                // Preserve the value of the "off" flag
                const off = valueDB.getValue(getOffStateValueID(this.endpoint.index));
                await this.set(value, off);
            }
            else if (property === "off") {
                if (typeof value !== "boolean") {
                    API_1.throwWrongValueType(this.ccId, property, "boolean", typeof value);
                }
                const mode = valueDB.getValue(getModeStateValueID(this.endpoint.index));
                if (mode == undefined) {
                    throw new core_1.ZWaveError(`The "off" property cannot be changed before the fan mode is known!`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
                await this.set(mode, value);
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (this.isSinglecast()) {
                // Verify the current value after a delay
                this.schedulePoll({ property });
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "mode":
                case "off":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ThermostatFanModeCommand.Get:
            case ThermostatFanModeCommand.SupportedGet:
                return this.isSinglecast();
            case ThermostatFanModeCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ThermostatFanModeCommand, ThermostatFanModeCommand.Get);
        const cc = new ThermostatModeCC_1.ThermostatModeCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["mode", "off"]);
        }
    }
    async set(mode, off) {
        this.assertSupportsCommand(ThermostatFanModeCommand, ThermostatFanModeCommand.Set);
        const cc = new ThermostatFanModeCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            mode,
            off,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getSupportedModes() {
        this.assertSupportsCommand(ThermostatFanModeCommand, ThermostatFanModeCommand.SupportedGet);
        const cc = new ThermostatFanModeCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedModes;
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
ThermostatFanModeCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Thermostat Fan Mode"])
], ThermostatFanModeCCAPI);
exports.ThermostatFanModeCCAPI = ThermostatFanModeCCAPI;
let ThermostatFanModeCC = class ThermostatFanModeCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Thermostat Fan Mode"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (complete) {
            // First query the possible modes to set the metadata
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying supported thermostat fan modes...",
                direction: "outbound",
            });
            const supportedModes = await api.getSupportedModes();
            if (supportedModes) {
                const logMessage = `received supported thermostat modes:${supportedModes
                    .map((mode) => `\n· ${shared_1.getEnumMemberName(ThermostatFanMode, mode)}`)
                    .join("")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying supported thermostat fan modes timed out, skipping interview...",
                });
                return;
            }
        }
        // Always query the actual status
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying current thermostat fan mode...",
            direction: "outbound",
        });
        const currentStatus = await api.get();
        if (currentStatus) {
            let logMessage = `received current thermostat fan mode: ${shared_1.getEnumMemberName(ThermostatFanMode, currentStatus.mode)}`;
            if (currentStatus.off != undefined) {
                logMessage += ` (turned off)`;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ThermostatFanModeCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Thermostat Fan Mode"]),
    CommandClass_1.implementedVersion(5)
], ThermostatFanModeCC);
exports.ThermostatFanModeCC = ThermostatFanModeCC;
let ThermostatFanModeCCSet = class ThermostatFanModeCCSet extends ThermostatFanModeCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.mode = options.mode;
            this.off = options.off;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            (this.version >= 2 && this.off ? 128 : 0) |
                (this.mode & 0b1111),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            mode: shared_1.getEnumMemberName(ThermostatFanMode, this.mode),
        };
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
ThermostatFanModeCCSet = __decorate([
    CommandClass_1.CCCommand(ThermostatFanModeCommand.Set)
], ThermostatFanModeCCSet);
exports.ThermostatFanModeCCSet = ThermostatFanModeCCSet;
let ThermostatFanModeCCReport = class ThermostatFanModeCCReport extends ThermostatFanModeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._mode = this.payload[0] & 0b1111;
        if (this.version >= 3) {
            this._off = !!(this.payload[0] & 128);
        }
        this.persistValues();
    }
    get mode() {
        return this._mode;
    }
    get off() {
        return this._off;
    }
    toLogEntry() {
        const message = {
            mode: shared_1.getEnumMemberName(ThermostatFanMode, this.mode),
        };
        if (this.off != undefined) {
            message.off = this.off;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        states: core_1.enumValuesToMetadataStates(ThermostatFanMode),
        label: "Thermostat fan mode",
    })
], ThermostatFanModeCCReport.prototype, "mode", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 3 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Boolean,
        label: "Thermostat fan turned off",
    })
], ThermostatFanModeCCReport.prototype, "off", null);
ThermostatFanModeCCReport = __decorate([
    CommandClass_1.CCCommand(ThermostatFanModeCommand.Report)
], ThermostatFanModeCCReport);
exports.ThermostatFanModeCCReport = ThermostatFanModeCCReport;
let ThermostatFanModeCCGet = class ThermostatFanModeCCGet extends ThermostatFanModeCC {
};
ThermostatFanModeCCGet = __decorate([
    CommandClass_1.CCCommand(ThermostatFanModeCommand.Get),
    CommandClass_1.expectedCCResponse(ThermostatFanModeCCReport)
], ThermostatFanModeCCGet);
exports.ThermostatFanModeCCGet = ThermostatFanModeCCGet;
let ThermostatFanModeCCSupportedReport = class ThermostatFanModeCCSupportedReport extends ThermostatFanModeCC {
    constructor(driver, options) {
        super(driver, options);
        this._supportedModes = core_1.parseBitMask(this.payload, ThermostatFanMode["Auto low"]);
        // Use this information to create the metadata for the mode property
        const valueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "mode",
        };
        // Only update the dynamic part
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.UInt8,
            states: core_1.enumValuesToMetadataStates(ThermostatFanMode, this._supportedModes),
        });
        this.persistValues();
    }
    get supportedModes() {
        return this._supportedModes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported modes": this.supportedModes
                    .map((mode) => `\n· ${shared_1.getEnumMemberName(ThermostatFanMode, mode)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ThermostatFanModeCCSupportedReport.prototype, "supportedModes", null);
ThermostatFanModeCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(ThermostatFanModeCommand.SupportedReport)
], ThermostatFanModeCCSupportedReport);
exports.ThermostatFanModeCCSupportedReport = ThermostatFanModeCCSupportedReport;
let ThermostatFanModeCCSupportedGet = class ThermostatFanModeCCSupportedGet extends ThermostatFanModeCC {
};
ThermostatFanModeCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(ThermostatFanModeCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(ThermostatFanModeCCSupportedReport)
], ThermostatFanModeCCSupportedGet);
exports.ThermostatFanModeCCSupportedGet = ThermostatFanModeCCSupportedGet;

//# sourceMappingURL=ThermostatFanModeCC.js.map
