/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { JSONObject } from "@zwave-js/shared";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "../commandclass/API";
import type { Driver } from "../driver/Driver";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum UserCodeCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    UsersNumberGet = 4,
    UsersNumberReport = 5,
    CapabilitiesGet = 6,
    CapabilitiesReport = 7,
    KeypadModeSet = 8,
    KeypadModeGet = 9,
    KeypadModeReport = 10,
    ExtendedUserCodeSet = 11,
    ExtendedUserCodeGet = 12,
    ExtendedUserCodeReport = 13,
    MasterCodeSet = 14,
    MasterCodeGet = 15,
    MasterCodeReport = 16,
    UserCodeChecksumGet = 17,
    UserCodeChecksumReport = 18
}
export declare enum UserIDStatus {
    Available = 0,
    Enabled = 1,
    Disabled = 2,
    Messaging = 3,
    PassageMode = 4,
    StatusNotAvailable = 254
}
export declare enum KeypadMode {
    Normal = 0,
    Vacation = 1,
    Privacy = 2,
    LockedOut = 3
}
export declare function getSupportedUsersValueID(endpoint: number | undefined): ValueID;
export declare function getUserIdStatusValueID(endpoint: number | undefined, userId: number): ValueID;
export declare function getUserCodeValueID(endpoint: number | undefined, userId: number): ValueID;
export declare function getUserCodeChecksumValueID(endpoint: number | undefined): ValueID;
export declare function getSupportsMasterCodeValueID(endpoint: number | undefined): ValueID;
export declare function getSupportsMasterCodeDeactivationValueID(endpoint: number | undefined): ValueID;
export declare function getSupportsUserCodeChecksumValueID(endpoint: number | undefined): ValueID;
export declare function getSupportedUserIDStatusesValueID(endpoint: number | undefined): ValueID;
export declare function getSupportedKeypadModesValueID(endpoint: number | undefined): ValueID;
export declare function getKeypadModeValueID(endpoint: number | undefined): ValueID;
export declare function getSupportedASCIICharsValueID(endpoint: number | undefined): ValueID;
export declare function getSupportsMultipleUserCodeSetValueID(endpoint: number | undefined): ValueID;
export declare class UserCodeCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: UserCodeCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    getUsersCount(): Promise<number | undefined>;
    get(userId: number, multiple?: false): Promise<Pick<UserCode, "userIdStatus" | "userCode"> | undefined>;
    get(userId: number, multiple: true): Promise<{
        userCodes: readonly UserCode[];
        nextUserId: number;
    } | undefined>;
    /** Configures a single user code */
    set(userId: number, userIdStatus: Exclude<UserIDStatus, UserIDStatus.Available | UserIDStatus.StatusNotAvailable>, userCode: string | Buffer): Promise<void>;
    /** Configures multiple user codes */
    setMany(codes: UserCodeCCSetOptions[]): Promise<void>;
    /**
     * Clears one or all user code
     * @param userId The user code to clear. If none or 0 is given, all codes are cleared
     */
    clear(userId?: number): Promise<void>;
    getCapabilities(): Promise<Pick<UserCodeCCCapabilitiesReport, "supportsMasterCode" | "supportsMasterCodeDeactivation" | "supportsUserCodeChecksum" | "supportedUserIDStatuses" | "supportedKeypadModes" | "supportedASCIIChars" | "supportsMultipleUserCodeSet" | "supportsMultipleUserCodeReport"> | undefined>;
    getKeypadMode(): Promise<KeypadMode | undefined>;
    setKeypadMode(keypadMode: KeypadMode): Promise<void>;
    getMasterCode(): Promise<string | undefined>;
    setMasterCode(masterCode: string): Promise<void>;
    getUserCodeChecksum(): Promise<number | undefined>;
}
export declare class UserCodeCC extends CommandClass {
    ccCommand: UserCodeCommand;
    interview(complete?: boolean): Promise<void>;
}
declare type UserCodeCCSetOptions = {
    userId: 0;
    userIdStatus: UserIDStatus.Available;
    userCode?: undefined;
} | {
    userId: number;
    userIdStatus: UserIDStatus.Available;
    userCode?: undefined;
} | {
    userId: number;
    userIdStatus: Exclude<UserIDStatus, UserIDStatus.Available | UserIDStatus.StatusNotAvailable>;
    userCode: string | Buffer;
};
export declare class UserCodeCCSet extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (CCCommandOptions & UserCodeCCSetOptions));
    userId: number;
    userIdStatus: UserIDStatus;
    userCode: string | Buffer;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
    toJSON(): JSONObject;
}
export declare class UserCodeCCReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly userId: number;
    readonly userIdStatus: UserIDStatus;
    readonly userCode: string | Buffer;
    persistValues(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
interface UserCodeCCGetOptions extends CCCommandOptions {
    userId: number;
}
export declare class UserCodeCCGet extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | UserCodeCCGetOptions);
    userId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCUsersNumberReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly supportedUsers: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCUsersNumberGet extends UserCodeCC {
}
export declare class UserCodeCCCapabilitiesReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly supportsMasterCode: boolean;
    readonly supportsMasterCodeDeactivation: boolean;
    readonly supportsUserCodeChecksum: boolean;
    readonly supportsMultipleUserCodeReport: boolean;
    readonly supportsMultipleUserCodeSet: boolean;
    readonly supportedUserIDStatuses: readonly UserIDStatus[];
    readonly supportedKeypadModes: readonly KeypadMode[];
    readonly supportedASCIIChars: string;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCCapabilitiesGet extends UserCodeCC {
}
interface UserCodeCCKeypadModeSetOptions extends CCCommandOptions {
    keypadMode: KeypadMode;
}
export declare class UserCodeCCKeypadModeSet extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | UserCodeCCKeypadModeSetOptions);
    keypadMode: KeypadMode;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCKeypadModeReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly keypadMode: KeypadMode;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCKeypadModeGet extends UserCodeCC {
}
interface UserCodeCCMasterCodeSetOptions extends CCCommandOptions {
    masterCode: string;
}
export declare class UserCodeCCMasterCodeSet extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | UserCodeCCMasterCodeSetOptions);
    masterCode: string;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCMasterCodeReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly masterCode: string;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCMasterCodeGet extends UserCodeCC {
}
export declare class UserCodeCCUserCodeChecksumReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly userCodeChecksum: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCUserCodeChecksumGet extends UserCodeCC {
}
export interface UserCodeCCExtendedUserCodeSetOptions extends CCCommandOptions {
    userCodes: UserCodeCCSetOptions[];
}
export interface UserCode {
    userId: number;
    userIdStatus: UserIDStatus;
    userCode: string;
}
export declare type SettableUserCode = UserCode & {
    userIdStatus: Exclude<UserIDStatus, UserIDStatus.StatusNotAvailable>;
};
export declare class UserCodeCCExtendedUserCodeSet extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | UserCodeCCExtendedUserCodeSetOptions);
    userCodes: SettableUserCode[];
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class UserCodeCCExtendedUserCodeReport extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly userCodes: readonly UserCode[];
    readonly nextUserId: number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface UserCodeCCExtendedUserCodeGetOptions extends CCCommandOptions {
    userId: number;
    reportMore?: boolean;
}
export declare class UserCodeCCExtendedUserCodeGet extends UserCodeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | UserCodeCCExtendedUserCodeGetOptions);
    userId: number;
    reportMore: boolean;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
