/// <reference types="node" />
import { CommandClasses, Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { ZWaveLibraryTypes } from "../controller/ZWaveLibraryTypes";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare function getFirmwareVersionsValueId(): ValueID;
export declare enum VersionCommand {
    Get = 17,
    Report = 18,
    CommandClassGet = 19,
    CommandClassReport = 20,
    CapabilitiesGet = 21,
    CapabilitiesReport = 22,
    ZWaveSoftwareGet = 23,
    ZWaveSoftwareReport = 24
}
export declare class VersionCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: VersionCommand): Maybe<boolean>;
    get(): Promise<Pick<VersionCCReport, "hardwareVersion" | "firmwareVersions" | "libraryType" | "protocolVersion"> | undefined>;
    getCCVersion(requestedCC: CommandClasses): Promise<number | undefined>;
    getCapabilities(): Promise<Pick<VersionCCCapabilitiesReport, "supportsZWaveSoftwareGet"> | undefined>;
    getZWaveSoftware(): Promise<Pick<VersionCCZWaveSoftwareReport, "sdkVersion" | "applicationFrameworkAPIVersion" | "applicationFrameworkBuildNumber" | "hostInterfaceVersion" | "hostInterfaceBuildNumber" | "zWaveProtocolVersion" | "zWaveProtocolBuildNumber" | "applicationVersion" | "applicationBuildNumber"> | undefined>;
}
export declare class VersionCC extends CommandClass {
    ccCommand: VersionCommand;
    determineRequiredCCInterviews(): readonly CommandClasses[];
    skipEndpointInterview(): boolean;
    interview(complete?: boolean): Promise<void>;
}
export declare class VersionCCReport extends VersionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _libraryType;
    get libraryType(): ZWaveLibraryTypes;
    private _protocolVersion;
    get protocolVersion(): string;
    private _firmwareVersions;
    get firmwareVersions(): string[];
    private _hardwareVersion;
    get hardwareVersion(): number | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class VersionCCGet extends VersionCC {
}
export declare class VersionCCCommandClassReport extends VersionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _ccVersion;
    get ccVersion(): number;
    private _requestedCC;
    get requestedCC(): CommandClasses;
    toLogEntry(): MessageOrCCLogEntry;
}
interface VersionCCCommandClassGetOptions extends CCCommandOptions {
    requestedCC: CommandClasses;
}
export declare class VersionCCCommandClassGet extends VersionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | VersionCCCommandClassGetOptions);
    requestedCC: CommandClasses;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class VersionCCCapabilitiesReport extends VersionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportsZWaveSoftwareGet;
    get supportsZWaveSoftwareGet(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class VersionCCCapabilitiesGet extends VersionCC {
}
export declare class VersionCCZWaveSoftwareReport extends VersionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _sdkVersion;
    get sdkVersion(): string;
    private _applicationFrameworkAPIVersion;
    get applicationFrameworkAPIVersion(): string;
    private _applicationFrameworkBuildNumber;
    get applicationFrameworkBuildNumber(): number;
    private _hostInterfaceVersion;
    get hostInterfaceVersion(): string;
    private _hostInterfaceBuildNumber;
    get hostInterfaceBuildNumber(): number;
    private _zWaveProtocolVersion;
    get zWaveProtocolVersion(): string;
    private _zWaveProtocolBuildNumber;
    get zWaveProtocolBuildNumber(): number;
    private _applicationVersion;
    get applicationVersion(): string;
    private _applicationBuildNumber;
    get applicationBuildNumber(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class VersionCCZWaveSoftwareGet extends VersionCC {
}
export {};
