/// <reference types="node" />
import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
import { DeviceClass } from "../node/DeviceClass";
export declare type Baudrate = 9600 | 40000 | 100000;
interface GetNodeProtocolInfoRequestOptions extends MessageBaseOptions {
    requestedNodeId: number;
}
export declare class GetNodeProtocolInfoRequest extends Message {
    constructor(driver: Driver, options: GetNodeProtocolInfoRequestOptions);
    requestedNodeId: number;
    serialize(): Buffer;
    toJSON(): JSONObject;
}
export declare class GetNodeProtocolInfoResponse extends Message {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    readonly isListening: boolean;
    readonly isFrequentListening: boolean;
    readonly isRouting: boolean;
    readonly maxBaudRate: Baudrate;
    readonly isController: boolean;
    readonly isRoutingSlave: boolean;
    readonly isSecure: boolean;
    readonly version: number;
    readonly isBeaming: boolean;
    readonly deviceClass: DeviceClass;
    toJSON(): JSONObject;
}
export {};
