"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNodeProtocolInfoResponse = exports.GetNodeProtocolInfoRequest = void 0;
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
const DeviceClass_1 = require("../node/DeviceClass");
var ProtocolFlags;
(function (ProtocolFlags) {
    ProtocolFlags[ProtocolFlags["Listening"] = 128] = "Listening";
    ProtocolFlags[ProtocolFlags["Routing"] = 64] = "Routing";
    ProtocolFlags[ProtocolFlags["Baudrate_100k"] = 24] = "Baudrate_100k";
    ProtocolFlags[ProtocolFlags["Baudrate_40k"] = 16] = "Baudrate_40k";
    ProtocolFlags[ProtocolFlags["Baudrate_9k6"] = 8] = "Baudrate_9k6";
    ProtocolFlags[ProtocolFlags["BaudrateMask"] = 56] = "BaudrateMask";
    ProtocolFlags[ProtocolFlags["VersionMask"] = 7] = "VersionMask";
})(ProtocolFlags || (ProtocolFlags = {}));
var DeviceCapabilityFlags;
(function (DeviceCapabilityFlags) {
    DeviceCapabilityFlags[DeviceCapabilityFlags["Security"] = 1] = "Security";
    DeviceCapabilityFlags[DeviceCapabilityFlags["Controller"] = 2] = "Controller";
    DeviceCapabilityFlags[DeviceCapabilityFlags["SpecificDevice"] = 4] = "SpecificDevice";
    DeviceCapabilityFlags[DeviceCapabilityFlags["RoutingSlave"] = 8] = "RoutingSlave";
    DeviceCapabilityFlags[DeviceCapabilityFlags["BeamCapability"] = 16] = "BeamCapability";
    DeviceCapabilityFlags[DeviceCapabilityFlags["Sensor250ms"] = 32] = "Sensor250ms";
    DeviceCapabilityFlags[DeviceCapabilityFlags["Sensor1000ms"] = 64] = "Sensor1000ms";
    DeviceCapabilityFlags[DeviceCapabilityFlags["OptionalFunctionality"] = 128] = "OptionalFunctionality";
})(DeviceCapabilityFlags || (DeviceCapabilityFlags = {}));
let GetNodeProtocolInfoRequest = class GetNodeProtocolInfoRequest extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this.requestedNodeId = options.requestedNodeId;
    }
    serialize() {
        this.payload = Buffer.from([this.requestedNodeId]);
        return super.serialize();
    }
    toJSON() {
        return super.toJSONInherited({
            nodeId: this.requestedNodeId,
        });
    }
};
GetNodeProtocolInfoRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.GetNodeProtocolInfo),
    Message_1.expectedResponse(Constants_1.FunctionType.GetNodeProtocolInfo),
    Message_1.priority(Constants_1.MessagePriority.Controller)
], GetNodeProtocolInfoRequest);
exports.GetNodeProtocolInfoRequest = GetNodeProtocolInfoRequest;
let GetNodeProtocolInfoResponse = class GetNodeProtocolInfoResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        const protocol = this.payload[0];
        this.isListening = (protocol & ProtocolFlags.Listening) !== 0;
        this.isRouting = (protocol & ProtocolFlags.Routing) !== 0;
        // This is an educated guess. OZW only checks for the 40k flag
        switch (protocol & ProtocolFlags.BaudrateMask) {
            case ProtocolFlags.Baudrate_100k:
                this.maxBaudRate = 100000;
                break;
            case ProtocolFlags.Baudrate_40k:
                this.maxBaudRate = 40000;
                break;
            case ProtocolFlags.Baudrate_9k6:
                this.maxBaudRate = 9600;
                break;
            default:
                // We don't know this baudrate yet, encode it as 0
                this.maxBaudRate = 0;
        }
        this.version = (protocol & ProtocolFlags.VersionMask) + 1;
        const capability = this.payload[1];
        this.isSecure = !!(capability & DeviceCapabilityFlags.Security);
        this.isFrequentListening = !!(capability &
            (DeviceCapabilityFlags.Sensor1000ms |
                DeviceCapabilityFlags.Sensor250ms));
        this.isBeaming = !!(capability & DeviceCapabilityFlags.BeamCapability);
        this.isRoutingSlave = !!(capability & DeviceCapabilityFlags.RoutingSlave);
        this.isController = !!(capability & DeviceCapabilityFlags.Controller);
        // parse the device class
        const basic = this.payload[3];
        const generic = this.payload[4];
        const specific = this.payload[5];
        this.deviceClass = new DeviceClass_1.DeviceClass(this.driver.configManager, basic, generic, specific);
    }
    toJSON() {
        return super.toJSONInherited({
            isListening: this.isListening,
            isFrequentListening: this.isFrequentListening,
            isRouting: this.isRouting,
            maxBaudRate: this.maxBaudRate,
            isSecure: this.isSecure,
            version: this.version,
            isBeaming: this.isBeaming,
            deviceClass: this.deviceClass,
        });
    }
};
GetNodeProtocolInfoResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.GetNodeProtocolInfo)
], GetNodeProtocolInfoResponse);
exports.GetNodeProtocolInfoResponse = GetNodeProtocolInfoResponse;

//# sourceMappingURL=GetNodeProtocolInfoMessages.js.map
