import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { FunctionType } from "../message/Constants";
import { Message, MessageDeserializationOptions } from "../message/Message";
export declare class GetSerialApiCapabilitiesRequest extends Message {
}
export declare class GetSerialApiCapabilitiesResponse extends Message {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _serialApiVersion;
    get serialApiVersion(): string;
    private _manufacturerId;
    get manufacturerId(): number;
    private _productType;
    get productType(): number;
    private _productId;
    get productId(): number;
    private _supportedFunctionTypes;
    get supportedFunctionTypes(): FunctionType[];
    toJSON(): JSONObject;
}
