import { ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import type { ZWaveNode } from "./Node";
import { VirtualEndpoint } from "./VirtualEndpoint";
export declare class VirtualNode extends VirtualEndpoint {
    readonly id: number | undefined;
    constructor(id: number | undefined, driver: Driver, 
    /** The references to the physical node this virtual node abstracts */
    physicalNodes: Iterable<ZWaveNode>);
    readonly physicalNodes: ZWaveNode[];
    /**
     * Updates a value for a given property of a given CommandClass.
     * This will communicate with the physical node(s) this virtual node represents!
     */
    setValue(valueId: ValueID, value: unknown): Promise<boolean>;
    /** Cache for this node's endpoint instances */
    private _endpointInstances;
    /**
     * Returns an endpoint of this node with the given index. 0 returns the node itself.
     */
    getEndpoint(index: 0): VirtualEndpoint;
    getEndpoint(index: number): VirtualEndpoint | undefined;
    /** Returns the current endpoint count of this virtual node (the maximum in the list of physical nodes) */
    getEndpointCount(): number;
    private get isMultiChannelInterviewComplete();
}
