"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initSentry = void 0;
// Load sentry.io so we get information about errors
const Integrations = __importStar(require("@sentry/integrations"));
const Sentry = __importStar(require("@sentry/node"));
const core_1 = require("@zwave-js/core");
const crypto_1 = require("crypto");
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
// Errors in files matching any entry in this array will always be reported
const pathWhitelists = ["node_modules/iobroker.zwave2"];
function isZWaveError(err) {
    if (!err || typeof err === "string")
        return false;
    return "code" in err && typeof err.code === "number";
}
async function initSentry(libraryRootDir, libName, libVersion) {
    /** Checks if a filename is part of this library. Paths outside will be excluded from Sentry error reporting */
    function isPartOfThisLib(filename) {
        const relative = path.relative(libraryRootDir, filename);
        return (!!relative &&
            !relative.startsWith("..") &&
            !path.isAbsolute(relative));
    }
    /** Creates a new fingerprint or retrieves a previously-generated one */
    async function getFingerprint() {
        const fingerprintPath = path.join(libraryRootDir, "fingerprint.txt");
        let fingerprint;
        if (await fs.pathExists(fingerprintPath)) {
            fingerprint = await fs.readFile(fingerprintPath, "utf8");
        }
        if (!fingerprint || fingerprint.length < 8) {
            fingerprint = crypto_1.randomBytes(8).toString("hex");
            try {
                await fs.writeFile(fingerprintPath, fingerprint, "utf8");
            }
            catch (_a) {
                /* ignore */
            }
        }
        return fingerprint;
    }
    Sentry.init({
        release: `${libName}@${libVersion}`,
        dsn: "https://a66de07edd064106853cc639407ebe64@sentry.iobroker.net/119",
        // "https://3ac1c1077df6496b89d797b331a8ec4a@o327859.ingest.sentry.io/1839595",
        defaultIntegrations: false,
        integrations: [
            new Sentry.Integrations.OnUncaughtException(),
            new Sentry.Integrations.OnUnhandledRejection({
                mode: "strict",
            }),
            new Sentry.Integrations.FunctionToString(),
            new Integrations.Dedupe(),
        ],
        maxBreadcrumbs: 30,
        beforeSend(event, hint) {
            var _a, _b, _c, _d, _e, _f;
            let ignore = false;
            // By default we ignore errors that original outside this library
            // Look at the last stackframe to figure out the filename
            const filename = (_f = (_e = (_d = (_c = (_b = (_a = event.exception) === null || _a === void 0 ? void 0 : _a.values) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.stacktrace) === null || _d === void 0 ? void 0 : _d.frames) === null || _e === void 0 ? void 0 : _e.slice(-1)[0]) === null || _f === void 0 ? void 0 : _f.filename;
            if (filename && !isPartOfThisLib(filename)) {
                ignore = true;
            }
            // Filter out specific errors that shouldn't create a report on sentry
            // because they should be handled by the library user
            if (!ignore && hint) {
                if (isZWaveError(hint.originalException)) {
                    switch (hint.originalException.code) {
                        // we don't care about timeouts
                        case core_1.ZWaveErrorCodes.Controller_MessageDropped:
                        // We don't care about failed node removal
                        case core_1.ZWaveErrorCodes.RemoveFailedNode_Failed:
                        case core_1.ZWaveErrorCodes.RemoveFailedNode_NodeOK:
                        // Or failed inclusion processes:
                        case core_1.ZWaveErrorCodes.Controller_InclusionFailed:
                        case core_1.ZWaveErrorCodes.Controller_ExclusionFailed:
                        // Or users that don't read the changelog:
                        case core_1.ZWaveErrorCodes.Driver_NoErrorHandler:
                            ignore = true;
                            break;
                        // Or users that try to manage associations on nodes that don't support it
                        case core_1.ZWaveErrorCodes.CC_NotSupported:
                            if (/does not support.+associations/.test(hint.originalException.message)) {
                                ignore = true;
                            }
                            break;
                    }
                    // Try to attach transaction context this way
                    if (!ignore && hint.originalException.transactionSource) {
                        event.contexts = {
                            transaction: {
                                stack: hint.originalException.transactionSource,
                            },
                        };
                    }
                }
                else if (hint.originalException instanceof Error) {
                    const msg = hint.originalException.message;
                    if (/(no such file|permission denied|cannot open|file not found)/i.test(msg) &&
                        /(\/dev\/|\/mqtt\/|COM\d+|Select Port)/i.test(msg)) {
                        // No such file or directory, cannot open /dev/ttyACM0
                        // no such file or directory, rename '/usr/src/app/store/mqtt/incoming~'
                        // Opening COM18: File not found
                        // No such file or directory, cannot open Select Port
                        ignore = true;
                    }
                    else if (/(EROFS|ENODEV|ENOSPC)/i.test(msg) &&
                        /(read-only file system|no such device|no space left)/i.test(msg)) {
                        // EROFS: read-only file system, write
                        // ENODEV: no such device, write
                        // ENOSPC: no space left on device, write
                        ignore = true;
                    }
                    else if (/unknown system error/i.test(msg)) {
                        // Unknown system error -116: Unknown system error -116, write
                        ignore = true;
                    }
                    else if (/custom baud rate/i.test(msg)) {
                        // Input/output error setting custom baud rate of 115200
                        ignore = true;
                    }
                    else if (/bindings\.node/i.test(msg)) {
                        // Could not locate the bindings file
                        ignore = true;
                    }
                }
            }
            // Don't ignore explicitly whitelisted paths
            if (ignore &&
                filename &&
                pathWhitelists.some((w) => path.normalize(filename).includes(path.normalize(w)))) {
                ignore = false;
            }
            return ignore ? null : event;
        },
    });
    // Try to group events by user (anonymously)
    try {
        const fingerprint = await getFingerprint();
        Sentry.configureScope((scope) => {
            scope.setUser({ id: fingerprint });
        });
    }
    catch (_a) {
        /* ignore */
    }
}
exports.initSentry = initSentry;

//# sourceMappingURL=sentry.js.map
