/*! @sentry/integrations 6.19.7 (5b3a175) | https://github.com/getsentry/sentry-javascript */
(function (__window) {
var exports = {};

/** This function adds duration since Sentry was initialized till the time event was sent */
class SessionTiming {
    constructor() {
        /**
         * @inheritDoc
         */
        this.name = SessionTiming.id;
        /** Exact time Client was initialized expressed in milliseconds since Unix Epoch. */
        this._startTime = Date.now();
    }
    /**
     * @inheritDoc
     */
    setupOnce(addGlobalEventProcessor, getCurrentHub) {
        addGlobalEventProcessor(event => {
            const self = getCurrentHub().getIntegration(SessionTiming);
            if (self) {
                return self.process(event);
            }
            return event;
        });
    }
    /**
     * @inheritDoc
     */
    process(event) {
        const now = Date.now();
        return Object.assign(Object.assign({}, event), { extra: Object.assign(Object.assign({}, event.extra), { ['session:start']: this._startTime, ['session:duration']: now - this._startTime, ['session:end']: now }) });
    }
}
/**
 * @inheritDoc
 */
SessionTiming.id = 'SessionTiming';

exports.SessionTiming = SessionTiming;


  // Add this module's exports to the global `Sentry.Integrations`
  __window.Sentry = __window.Sentry || {};
  __window.Sentry.Integrations = __window.Sentry.Integrations || {};
  for (var key in exports) {
    if (Object.prototype.hasOwnProperty.call(exports, key)) {
      __window.Sentry.Integrations[key] = exports[key];
    }
  }
}(window));
//# sourceMappingURL=sessiontiming.es6.js.map
