/*! @sentry/integrations 6.19.7 (5b3a175) | https://github.com/getsentry/sentry-javascript */
(function (__window) {
var exports = {};

/** Add node transaction to the event */
class Transaction {
    constructor() {
        /**
         * @inheritDoc
         */
        this.name = Transaction.id;
    }
    /**
     * @inheritDoc
     */
    setupOnce(addGlobalEventProcessor, getCurrentHub) {
        addGlobalEventProcessor(event => {
            const self = getCurrentHub().getIntegration(Transaction);
            if (self) {
                return self.process(event);
            }
            return event;
        });
    }
    /**
     * @inheritDoc
     */
    process(event) {
        const frames = this._getFramesFromEvent(event);
        // use for loop so we don't have to reverse whole frames array
        for (let i = frames.length - 1; i >= 0; i--) {
            const frame = frames[i];
            if (frame.in_app === true) {
                event.transaction = this._getTransaction(frame);
                break;
            }
        }
        return event;
    }
    /** JSDoc */
    _getFramesFromEvent(event) {
        const exception = event.exception && event.exception.values && event.exception.values[0];
        return (exception && exception.stacktrace && exception.stacktrace.frames) || [];
    }
    /** JSDoc */
    _getTransaction(frame) {
        return frame.module || frame.function ? `${frame.module || '?'}/${frame.function || '?'}` : '<unknown>';
    }
}
/**
 * @inheritDoc
 */
Transaction.id = 'Transaction';

exports.Transaction = Transaction;


  // Add this module's exports to the global `Sentry.Integrations`
  __window.Sentry = __window.Sentry || {};
  __window.Sentry.Integrations = __window.Sentry.Integrations || {};
  for (var key in exports) {
    if (Object.prototype.hasOwnProperty.call(exports, key)) {
      __window.Sentry.Integrations[key] = exports[key];
    }
  }
}(window));
//# sourceMappingURL=transaction.es6.js.map
