/*! @sentry/integrations 6.19.7 (5b3a175) | https://github.com/getsentry/sentry-javascript */
(function (__window) {
var exports = {};

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/**
 * NOTE: In order to avoid circular dependencies, if you add a function to this module and it needs to print something,
 * you must either a) use `console.log` rather than the logger, or b) put your function elsewhere.
 */
var fallbackGlobalObject = {};
/**
 * Safely get global scope object
 *
 * @returns Global scope object
 */
function getGlobalObject() {
    return (typeof window !== 'undefined' // eslint-disable-line no-restricted-globals
            ? window // eslint-disable-line no-restricted-globals
            : typeof self !== 'undefined'
                ? self
                : fallbackGlobalObject);
}
/**
 * Returns a global singleton contained in the global `__SENTRY__` object.
 *
 * If the singleton doesn't already exist in `__SENTRY__`, it will be created using the given factory
 * function and added to the `__SENTRY__` object.
 *
 * @param name name of the global singleton on __SENTRY__
 * @param creator creator Factory function to create the singleton if it doesn't already exist on `__SENTRY__`
 * @param obj (Optional) The global object on which to look for `__SENTRY__`, if not `getGlobalObject`'s return value
 * @returns the singleton
 */
function getGlobalSingleton(name, creator, obj) {
    var global = (obj || getGlobalObject());
    var __SENTRY__ = (global.__SENTRY__ = global.__SENTRY__ || {});
    var singleton = __SENTRY__[name] || (__SENTRY__[name] = creator());
    return singleton;
}

/*
 * This file defines flags and constants that can be modified during compile time in order to facilitate tree shaking
 * for users.
 *
 * Debug flags need to be declared in each package individually and must not be imported across package boundaries,
 * because some build tools have trouble tree-shaking imported guards.
 *
 * As a convention, we define debug flags in a `flags.ts` file in the root of a package's `src` folder.
 *
 * Debug flag files will contain "magic strings" like `true` that may get replaced with actual values during
 * our, or the user's build process. Take care when introducing new flags - they must not throw if they are not
 * replaced.
 */
/** Flag that is true for debug builds, false otherwise. */
var IS_DEBUG_BUILD$1 = true;

// TODO: Implement different loggers for different environments
var global = getGlobalObject();
/** Prefix for logging strings */
var PREFIX = 'Sentry Logger ';
var CONSOLE_LEVELS = ['debug', 'info', 'warn', 'error', 'log', 'assert'];
/**
 * Temporarily disable sentry console instrumentations.
 *
 * @param callback The function to run against the original `console` messages
 * @returns The results of the callback
 */
function consoleSandbox(callback) {
    var global = getGlobalObject();
    if (!('console' in global)) {
        return callback();
    }
    var originalConsole = global.console;
    var wrappedLevels = {};
    // Restore all wrapped console methods
    CONSOLE_LEVELS.forEach(function (level) {
        // TODO(v7): Remove this check as it's only needed for Node 6
        var originalWrappedFunc = originalConsole[level] && originalConsole[level].__sentry_original__;
        if (level in global.console && originalWrappedFunc) {
            wrappedLevels[level] = originalConsole[level];
            originalConsole[level] = originalWrappedFunc;
        }
    });
    try {
        return callback();
    }
    finally {
        // Revert restoration to wrapped state
        Object.keys(wrappedLevels).forEach(function (level) {
            originalConsole[level] = wrappedLevels[level];
        });
    }
}
function makeLogger() {
    var enabled = false;
    var logger = {
        enable: function () {
            enabled = true;
        },
        disable: function () {
            enabled = false;
        },
    };
    if (IS_DEBUG_BUILD$1) {
        CONSOLE_LEVELS.forEach(function (name) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            logger[name] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (enabled) {
                    consoleSandbox(function () {
                        var _a;
                        (_a = global.console)[name].apply(_a, __spread([PREFIX + "[" + name + "]:"], args));
                    });
                }
            };
        });
    }
    else {
        CONSOLE_LEVELS.forEach(function (name) {
            logger[name] = function () { return undefined; };
        });
    }
    return logger;
}
// Ensure we only have a single logger instance, even if multiple versions of @sentry/utils are being used
var logger;
if (IS_DEBUG_BUILD$1) {
    logger = getGlobalSingleton('logger', makeLogger);
}
else {
    logger = makeLogger();
}

// Slightly modified (no IE8 support, ES6) and transcribed to TypeScript
// Split a filename into [root, dir, basename, ext], unix version
// 'root' is just a slash, or nothing.
var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^/]+?|)(\.[^./]*|))(?:[/]*)$/;
/** JSDoc */
function splitPath(filename) {
    var parts = splitPathRe.exec(filename);
    return parts ? parts.slice(1) : [];
}
/** JSDoc */
function basename(path, ext) {
    var f = splitPath(path)[2];
    if (ext && f.substr(ext.length * -1) === ext) {
        f = f.substr(0, f.length - ext.length);
    }
    return f;
}

/**
 * A TimestampSource implementation for environments that do not support the Performance Web API natively.
 *
 * Note that this TimestampSource does not use a monotonic clock. A call to `nowSeconds` may return a timestamp earlier
 * than a previously returned value. We do not try to emulate a monotonic behavior in order to facilitate debugging. It
 * is more obvious to explain "why does my span have negative duration" than "why my spans have zero duration".
 */
var dateTimestampSource = {
    nowSeconds: function () { return Date.now() / 1000; },
};
/**
 * Returns a wrapper around the native Performance API browser implementation, or undefined for browsers that do not
 * support the API.
 *
 * Wrapping the native API works around differences in behavior from different browsers.
 */
function getBrowserPerformance() {
    var performance = getGlobalObject().performance;
    if (!performance || !performance.now) {
        return undefined;
    }
    // Replace performance.timeOrigin with our own timeOrigin based on Date.now().
    //
    // This is a partial workaround for browsers reporting performance.timeOrigin such that performance.timeOrigin +
    // performance.now() gives a date arbitrarily in the past.
    //
    // Additionally, computing timeOrigin in this way fills the gap for browsers where performance.timeOrigin is
    // undefined.
    //
    // The assumption that performance.timeOrigin + performance.now() ~= Date.now() is flawed, but we depend on it to
    // interact with data coming out of performance entries.
    //
    // Note that despite recommendations against it in the spec, browsers implement the Performance API with a clock that
    // might stop when the computer is asleep (and perhaps under other circumstances). Such behavior causes
    // performance.timeOrigin + performance.now() to have an arbitrary skew over Date.now(). In laptop computers, we have
    // observed skews that can be as long as days, weeks or months.
    //
    // See https://github.com/getsentry/sentry-javascript/issues/2590.
    //
    // BUG: despite our best intentions, this workaround has its limitations. It mostly addresses timings of pageload
    // transactions, but ignores the skew built up over time that can aversely affect timestamps of navigation
    // transactions of long-lived web pages.
    var timeOrigin = Date.now() - performance.now();
    return {
        now: function () { return performance.now(); },
        timeOrigin: timeOrigin,
    };
}
/**
 * The Performance API implementation for the current platform, if available.
 */
var platformPerformance = getBrowserPerformance();
var timestampSource = platformPerformance === undefined
    ? dateTimestampSource
    : {
        nowSeconds: function () { return (platformPerformance.timeOrigin + platformPerformance.now()) / 1000; },
    };
/**
 * Returns a timestamp in seconds since the UNIX epoch using the Date API.
 */
dateTimestampSource.nowSeconds.bind(dateTimestampSource);
/**
 * Returns a timestamp in seconds since the UNIX epoch using either the Performance or Date APIs, depending on the
 * availability of the Performance API.
 *
 * See `usingPerformanceAPI` to test whether the Performance API is used.
 *
 * BUG: Note that because of how browsers implement the Performance API, the clock might stop when the computer is
 * asleep. This creates a skew between `dateTimestampInSeconds` and `timestampInSeconds`. The
 * skew can grow to arbitrary amounts like days, weeks or months.
 * See https://github.com/getsentry/sentry-javascript/issues/2590.
 */
var timestampInSeconds = timestampSource.nowSeconds.bind(timestampSource);
// Re-exported with an old name for backwards-compatibility.
var timestampWithMs = timestampInSeconds;
/**
 * The number of milliseconds since the UNIX epoch. This value is only usable in a browser, and only when the
 * performance API is available.
 */
((function () {
    // Unfortunately browsers may report an inaccurate time origin data, through either performance.timeOrigin or
    // performance.timing.navigationStart, which results in poor results in performance data. We only treat time origin
    // data as reliable if they are within a reasonable threshold of the current time.
    var performance = getGlobalObject().performance;
    if (!performance || !performance.now) {
        return undefined;
    }
    var threshold = 3600 * 1000;
    var performanceNow = performance.now();
    var dateNow = Date.now();
    // if timeOrigin isn't available set delta to threshold so it isn't used
    var timeOriginDelta = performance.timeOrigin
        ? Math.abs(performance.timeOrigin + performanceNow - dateNow)
        : threshold;
    var timeOriginIsReliable = timeOriginDelta < threshold;
    // While performance.timing.navigationStart is deprecated in favor of performance.timeOrigin, performance.timeOrigin
    // is not as widely supported. Namely, performance.timeOrigin is undefined in Safari as of writing.
    // Also as of writing, performance.timing is not available in Web Workers in mainstream browsers, so it is not always
    // a valid fallback. In the absence of an initial time provided by the browser, fallback to the current time from the
    // Date API.
    // eslint-disable-next-line deprecation/deprecation
    var navigationStart = performance.timing && performance.timing.navigationStart;
    var hasNavigationStart = typeof navigationStart === 'number';
    // if navigationStart isn't available set delta to threshold so it isn't used
    var navigationStartDelta = hasNavigationStart ? Math.abs(navigationStart + performanceNow - dateNow) : threshold;
    var navigationStartIsReliable = navigationStartDelta < threshold;
    if (timeOriginIsReliable || navigationStartIsReliable) {
        // Use the more reliable time origin
        if (timeOriginDelta <= navigationStartDelta) {
            return performance.timeOrigin;
        }
        else {
            return navigationStart;
        }
    }
    return dateNow;
}))();

/*
 * This file defines flags and constants that can be modified during compile time in order to facilitate tree shaking
 * for users.
 *
 * Debug flags need to be declared in each package individually and must not be imported across package boundaries,
 * because some build tools have trouble tree-shaking imported guards.
 *
 * As a convention, we define debug flags in a `flags.ts` file in the root of a package's `src` folder.
 *
 * Debug flag files will contain "magic strings" like `true` that may get replaced with actual values during
 * our, or the user's build process. Take care when introducing new flags - they must not throw if they are not
 * replaced.
 */
/** Flag that is true for debug builds, false otherwise. */
var IS_DEBUG_BUILD = true;

/**
 * Used to extract Tracing integration from the current client,
 * without the need to import `Tracing` itself from the @sentry/apm package.
 * @deprecated as @sentry/tracing should be used over @sentry/apm.
 */
var TRACING_GETTER = {
    id: 'Tracing',
};
/**
 * Used to extract BrowserTracing integration from @sentry/tracing
 */
var BROWSER_TRACING_GETTER = {
    id: 'BrowserTracing',
};
var VUE_OP = 'ui.vue';
// Mappings from operation to corresponding lifecycle hook.
var HOOKS = {
    activate: ['activated', 'deactivated'],
    create: ['beforeCreate', 'created'],
    destroy: ['beforeDestroy', 'destroyed'],
    mount: ['beforeMount', 'mounted'],
    update: ['beforeUpdate', 'updated'],
};
var COMPONENT_NAME_REGEXP = /(?:^|[-_/])(\w)/g;
var ROOT_COMPONENT_NAME = 'root';
var ANONYMOUS_COMPONENT_NAME = 'anonymous component';
/** JSDoc */
var Vue = /** @class */ (function () {
    /**
     * @inheritDoc
     */
    function Vue(options) {
        var _this = this;
        /**
         * @inheritDoc
         */
        this.name = Vue.id;
        /**
         * Cache holding already processed component names
         */
        this._componentsCache = {};
        /** Keep it as attribute function, to keep correct `this` binding inside the hooks callbacks  */
        // eslint-disable-next-line @typescript-eslint/typedef
        this._applyTracingHooks = function (vm, getCurrentHub) {
            // Don't attach twice, just in case
            if (vm.$options.$_sentryPerfHook) {
                return;
            }
            vm.$options.$_sentryPerfHook = true;
            var name = _this._getComponentName(vm);
            var rootMount = name === ROOT_COMPONENT_NAME;
            var spans = {};
            // Render hook starts after once event is emitted,
            // but it ends before the second event of the same type.
            //
            // Because of this, we start measuring inside the first event,
            // but finish it before it triggers, to skip the event emitter timing itself.
            var rootHandler = function (hook) {
                var now = timestampWithMs();
                // On the first handler call (before), it'll be undefined, as `$once` will add it in the future.
                // However, on the second call (after), it'll be already in place.
                if (_this._rootSpan) {
                    _this._finishRootSpan(now, getCurrentHub);
                }
                else {
                    vm.$once("hook:" + hook, function () {
                        // Create an activity on the first event call. There'll be no second call, as rootSpan will be in place,
                        // thus new event handler won't be attached.
                        // We do this whole dance with `TRACING_GETTER` to prevent `@sentry/apm` from becoming a peerDependency.
                        // We also need to ask for the `.constructor`, as `pushActivity` and `popActivity` are static, not instance methods.
                        /* eslint-disable @typescript-eslint/no-unsafe-member-access */
                        // eslint-disable-next-line deprecation/deprecation
                        var tracingIntegration = getCurrentHub().getIntegration(TRACING_GETTER);
                        if (tracingIntegration) {
                            _this._tracingActivity = tracingIntegration.constructor.pushActivity('Vue Application Render');
                            var transaction = tracingIntegration.constructor.getTransaction();
                            if (transaction) {
                                _this._rootSpan = transaction.startChild({
                                    description: 'Application Render',
                                    op: VUE_OP,
                                });
                            }
                            // Use functionality from @sentry/tracing
                        }
                        else {
                            var activeTransaction = getActiveTransaction(getCurrentHub());
                            if (activeTransaction) {
                                _this._rootSpan = activeTransaction.startChild({
                                    description: 'Application Render',
                                    op: VUE_OP,
                                });
                            }
                        }
                        /* eslint-enable @typescript-eslint/no-unsafe-member-access */
                    });
                }
            };
            var childHandler = function (hook, operation) {
                // Skip components that we don't want to track to minimize the noise and give a more granular control to the user
                var shouldTrack = Array.isArray(_this._options.tracingOptions.trackComponents)
                    ? _this._options.tracingOptions.trackComponents.indexOf(name) > -1
                    : _this._options.tracingOptions.trackComponents;
                if (!_this._rootSpan || !shouldTrack) {
                    return;
                }
                var now = timestampWithMs();
                var span = spans[operation];
                // On the first handler call (before), it'll be undefined, as `$once` will add it in the future.
                // However, on the second call (after), it'll be already in place.
                if (span) {
                    span.finish();
                    _this._finishRootSpan(now, getCurrentHub);
                }
                else {
                    vm.$once("hook:" + hook, function () {
                        if (_this._rootSpan) {
                            spans[operation] = _this._rootSpan.startChild({
                                description: "Vue <" + name + ">",
                                op: VUE_OP + "." + operation,
                            });
                        }
                    });
                }
            };
            // Each component has it's own scope, so all activities are only related to one of them
            _this._options.tracingOptions.hooks.forEach(function (operation) {
                // Retrieve corresponding hooks from Vue lifecycle.
                // eg. mount => ['beforeMount', 'mounted']
                var internalHooks = HOOKS[operation];
                if (!internalHooks) {
                    logger.warn("Unknown hook: " + operation);
                    return;
                }
                internalHooks.forEach(function (internalHook) {
                    var handler = rootMount
                        ? rootHandler.bind(_this, internalHook)
                        : childHandler.bind(_this, internalHook, operation);
                    var currentValue = vm.$options[internalHook];
                    if (Array.isArray(currentValue)) {
                        vm.$options[internalHook] = __spread([handler], currentValue);
                    }
                    else if (typeof currentValue === 'function') {
                        vm.$options[internalHook] = [handler, currentValue];
                    }
                    else {
                        vm.$options[internalHook] = [handler];
                    }
                });
            });
        };
        logger.log('You are still using the Vue.js integration, consider moving to @sentry/vue');
        this._options = __assign(__assign({ 
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
            Vue: getGlobalObject().Vue, attachProps: true, logErrors: false, tracing: false }, options), { tracingOptions: __assign({ hooks: ['mount', 'update'], timeout: 2000, trackComponents: false }, options.tracingOptions) });
    }
    /**
     * @inheritDoc
     */
    Vue.prototype.setupOnce = function (_, getCurrentHub) {
        if (!this._options.Vue) {
            IS_DEBUG_BUILD && logger.error('Vue integration is missing a Vue instance');
            return;
        }
        this._attachErrorHandler(getCurrentHub);
        if (this._options.tracing) {
            this._startTracing(getCurrentHub);
        }
    };
    /**
     * Extract component name from the ViewModel
     */
    Vue.prototype._getComponentName = function (vm) {
        // Such level of granularity is most likely not necessary, but better safe than sorry. — Kamil
        if (!vm) {
            return ANONYMOUS_COMPONENT_NAME;
        }
        if (vm.$root === vm) {
            return ROOT_COMPONENT_NAME;
        }
        if (!vm.$options) {
            return ANONYMOUS_COMPONENT_NAME;
        }
        if (vm.$options.name) {
            return vm.$options.name;
        }
        if (vm.$options._componentTag) {
            return vm.$options._componentTag;
        }
        // injected by vue-loader
        if (vm.$options.__file) {
            var unifiedFile = vm.$options.__file.replace(/^[a-zA-Z]:/, '').replace(/\\/g, '/');
            var filename = basename(unifiedFile, '.vue');
            return (this._componentsCache[filename] ||
                (this._componentsCache[filename] = filename.replace(COMPONENT_NAME_REGEXP, function (_, c) {
                    return c ? c.toUpperCase() : '';
                })));
        }
        return ANONYMOUS_COMPONENT_NAME;
    };
    /** Finish top-level span and activity with a debounce configured using `timeout` option */
    Vue.prototype._finishRootSpan = function (timestamp, getCurrentHub) {
        var _this = this;
        if (this._rootSpanTimer) {
            clearTimeout(this._rootSpanTimer);
        }
        this._rootSpanTimer = setTimeout(function () {
            if (_this._tracingActivity) {
                // We do this whole dance with `TRACING_GETTER` to prevent `@sentry/apm` from becoming a peerDependency.
                // We also need to ask for the `.constructor`, as `pushActivity` and `popActivity` are static, not instance methods.
                // eslint-disable-next-line deprecation/deprecation
                var tracingIntegration = getCurrentHub().getIntegration(TRACING_GETTER);
                if (tracingIntegration) {
                    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
                    tracingIntegration.constructor.popActivity(_this._tracingActivity);
                }
            }
            // We should always finish the span, only should pop activity if using @sentry/apm
            if (_this._rootSpan) {
                _this._rootSpan.finish(timestamp);
            }
        }, this._options.tracingOptions.timeout);
    };
    /** Inject configured tracing hooks into Vue's component lifecycles */
    Vue.prototype._startTracing = function (getCurrentHub) {
        var applyTracingHooks = this._applyTracingHooks;
        this._options.Vue.mixin({
            beforeCreate: function () {
                // eslint-disable-next-line deprecation/deprecation
                if (getCurrentHub().getIntegration(TRACING_GETTER) || getCurrentHub().getIntegration(BROWSER_TRACING_GETTER)) {
                    // `this` points to currently rendered component
                    applyTracingHooks(this, getCurrentHub);
                }
                else {
                    IS_DEBUG_BUILD &&
                        logger.error('Vue integration has tracing enabled, but Tracing integration is not configured');
                }
            },
        });
    };
    /** Inject Sentry's handler into owns Vue's error handler  */
    Vue.prototype._attachErrorHandler = function (getCurrentHub) {
        var _this = this;
        // eslint-disable-next-line @typescript-eslint/unbound-method
        var currentErrorHandler = this._options.Vue.config.errorHandler;
        this._options.Vue.config.errorHandler = function (error, vm, info) {
            var metadata = {};
            if (vm) {
                try {
                    metadata.componentName = _this._getComponentName(vm);
                    if (_this._options.attachProps) {
                        metadata.propsData = vm.$options.propsData;
                    }
                }
                catch (_oO) {
                    IS_DEBUG_BUILD && logger.warn('Unable to extract metadata from Vue component.');
                }
            }
            if (info) {
                metadata.lifecycleHook = info;
            }
            if (getCurrentHub().getIntegration(Vue)) {
                // Capture exception in the next event loop, to make sure that all breadcrumbs are recorded in time.
                setTimeout(function () {
                    getCurrentHub().withScope(function (scope) {
                        scope.setContext('vue', metadata);
                        getCurrentHub().captureException(error);
                    });
                });
            }
            if (typeof currentErrorHandler === 'function') {
                currentErrorHandler.call(_this._options.Vue, error, vm, info);
            }
            if (_this._options.logErrors) {
                if (_this._options.Vue.util) {
                    _this._options.Vue.util.warn("Error in " + info + ": \"" + (error && error.toString()) + "\"", vm);
                }
                // eslint-disable-next-line no-console
                console.error(error);
            }
        };
    };
    /**
     * @inheritDoc
     */
    Vue.id = 'Vue';
    return Vue;
}());
/** Grabs active transaction off scope */
function getActiveTransaction(hub) {
    if (hub && hub.getScope) {
        var scope = hub.getScope();
        if (scope) {
            return scope.getTransaction();
        }
    }
    return undefined;
}

exports.Vue = Vue;
exports.getActiveTransaction = getActiveTransaction;


  // Add this module's exports to the global `Sentry.Integrations`
  __window.Sentry = __window.Sentry || {};
  __window.Sentry.Integrations = __window.Sentry.Integrations || {};
  for (var key in exports) {
    if (Object.prototype.hasOwnProperty.call(exports, key)) {
      __window.Sentry.Integrations[key] = exports[key];
    }
  }
}(window));
//# sourceMappingURL=vue.js.map
