import { EventProcessor, Hub, Integration } from '@sentry/types';
interface DebugOptions {
    /** Controls whether console output created by this integration should be stringified. Default: `false` */
    stringify?: boolean;
    /** Controls whether a debugger should be launched before an event is sent. Default: `false` */
    debugger?: boolean;
}
/**
 * Integration to debug sent Sentry events.
 * This integration should not be used in production
 */
export declare class Debug implements Integration {
    /**
     * @inheritDoc
     */
    static id: string;
    /**
     * @inheritDoc
     */
    name: string;
    private readonly _options;
    constructor(options?: DebugOptions);
    /**
     * @inheritDoc
     */
    setupOnce(addGlobalEventProcessor: (callback: EventProcessor) => void, getCurrentHub: () => Hub): void;
}
export {};
//# sourceMappingURL=debug.d.ts.map