import { __assign } from "tslib";
import { consoleSandbox } from '@sentry/utils';
/**
 * Integration to debug sent Sentry events.
 * This integration should not be used in production
 */
var Debug = /** @class */ (function () {
    function Debug(options) {
        /**
         * @inheritDoc
         */
        this.name = Debug.id;
        this._options = __assign({ debugger: false, stringify: false }, options);
    }
    /**
     * @inheritDoc
     */
    Debug.prototype.setupOnce = function (addGlobalEventProcessor, getCurrentHub) {
        addGlobalEventProcessor(function (event, hint) {
            var self = getCurrentHub().getIntegration(Debug);
            if (self) {
                if (self._options.debugger) {
                    // eslint-disable-next-line no-debugger
                    debugger;
                }
                /* eslint-disable no-console */
                consoleSandbox(function () {
                    if (self._options.stringify) {
                        console.log(JSON.stringify(event, null, 2));
                        if (hint) {
                            console.log(JSON.stringify(hint, null, 2));
                        }
                    }
                    else {
                        console.log(event);
                        if (hint) {
                            console.log(hint);
                        }
                    }
                });
                /* eslint-enable no-console */
            }
            return event;
        });
    };
    /**
     * @inheritDoc
     */
    Debug.id = 'Debug';
    return Debug;
}());
export { Debug };
//# sourceMappingURL=debug.js.map