"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValueMetadata = exports.enumValuesToMetadataStates = exports.getNumericEnumValues = void 0;
const shared_1 = require("@zwave-js/shared");
const Primitive_1 = require("./Primitive");
const isIntegerRegex = /^\d+$/;
/** Returns an array with the values of a numeric enum */
function getNumericEnumValues(enumeration) {
    return Object.keys(enumeration)
        .filter((val) => isIntegerRegex.test(val))
        .map((val) => parseInt(val, 10));
}
exports.getNumericEnumValues = getNumericEnumValues;
/** Takes an enumeration and an array of values of this enumeration and returns a states record to be used as metadata */
function enumValuesToMetadataStates(enumeration, values) {
    const ret = {};
    if (values == undefined)
        values = getNumericEnumValues(enumeration);
    for (const value of values) {
        ret[value] = shared_1.getEnumMemberName(enumeration, value);
    }
    return ret;
}
exports.enumValuesToMetadataStates = enumValuesToMetadataStates;
// TODO: lists of allowed values, etc...
// Mixins for value metadata
const _default = {
    type: "any",
    readable: true,
    writeable: true,
};
const _readonly = {
    writeable: false,
};
const _writeonly = {
    readable: false,
};
/** The default value for metadata: readable and writeable */
const Any = {
    ..._default,
};
/** The default value for readonly metadata */
const ReadOnly = {
    ..._default,
    ..._readonly,
};
/** The default value for writeonly metadata */
const WriteOnly = {
    ..._default,
    ..._writeonly,
};
/** A boolean value */
const Boolean = {
    ..._default,
    type: "boolean",
};
/** A boolean value (readonly) */
const ReadOnlyBoolean = {
    ...Boolean,
    ..._readonly,
};
/** A boolean value (writeonly) */
const WriteOnlyBoolean = {
    ...Boolean,
    ..._writeonly,
};
/** Any number */
const Number = {
    ..._default,
    type: "number",
};
/** Unsigned number (readonly) */
const ReadOnlyNumber = {
    ...Number,
    ..._readonly,
};
/** Unsigned number (writeonly) */
const WriteOnlyNumber = {
    ...Number,
    ..._writeonly,
};
/** Unsigned 8-bit integer */
const UInt8 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.UInt8,
};
/** Unsigned 8-bit integer (readonly) */
const ReadOnlyUInt8 = {
    ...UInt8,
    ..._readonly,
};
/** Unsigned 8-bit integer (writeonly) */
const WriteOnlyUInt8 = {
    ...UInt8,
    ..._writeonly,
};
/** Unsigned 16-bit integer */
const UInt16 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.UInt16,
};
/** Unsigned 16-bit integer (readonly) */
const ReadOnlyUInt16 = {
    ...UInt16,
    ..._readonly,
};
/** Unsigned 16-bit integer (writeonly) */
const WriteOnlyUInt16 = {
    ...UInt16,
    ..._writeonly,
};
/** Unsigned 24-bit integer */
const UInt24 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.UInt24,
};
/** Unsigned 24-bit integer (readonly) */
const ReadOnlyUInt24 = {
    ...UInt24,
    ..._readonly,
};
/** Unsigned 24-bit integer (writeonly) */
const WriteOnlyUInt24 = {
    ...UInt24,
    ..._writeonly,
};
/** Unsigned 32-bit integer */
const UInt32 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.UInt32,
};
/** Unsigned 32-bit integer (readonly) */
const ReadOnlyUInt32 = {
    ...UInt32,
    ..._readonly,
};
/** Unsigned 32-bit integer (writeonly) */
const WriteOnlyUInt32 = {
    ...UInt32,
    ..._writeonly,
};
/** Signed 8-bit integer */
const Int8 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.Int8,
};
/** Signed 8-bit integer (readonly) */
const ReadOnlyInt8 = {
    ...Int8,
    ..._readonly,
};
/** Signed 8-bit integer (writeonly) */
const WriteOnlyInt8 = {
    ...Int8,
    ..._writeonly,
};
/** Signed 16-bit integer */
const Int16 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.Int16,
};
/** Signed 16-bit integer (readonly) */
const ReadOnlyInt16 = {
    ...Int16,
    ..._readonly,
};
/** Signed 16-bit integer (writeonly) */
const WriteOnlyInt16 = {
    ...Int16,
    ..._writeonly,
};
/** Signed 24-bit integer */
const Int24 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.Int24,
};
/** Signed 24-bit integer (readonly) */
const ReadOnlyInt24 = {
    ...Int24,
    ..._readonly,
};
/** Signed 24-bit integer (writeonly) */
const WriteOnlyInt24 = {
    ...Int24,
    ..._writeonly,
};
/** Signed 32-bit integer */
const Int32 = {
    ..._default,
    type: "number",
    ...Primitive_1.IntegerLimits.Int32,
};
/** Signed 32-bit integer (readonly) */
const ReadOnlyInt32 = {
    ...Int32,
    ..._readonly,
};
/** Signed 32-bit integer (writeonly) */
const WriteOnlyInt32 = {
    ...Int32,
    ..._writeonly,
};
/** Any string */
const String = {
    ..._default,
    type: "string",
};
/** Any string (readonly) */
const ReadOnlyString = {
    ...String,
    ..._readonly,
};
/** Any string (writeonly) */
const WriteOnlyString = {
    ...String,
    ..._writeonly,
};
/** A (hex) string that represents a color */
const Color = {
    ...String,
    type: "color",
};
/** A (hex) string that represents a color (readonly) */
const ReadOnlyColor = {
    ...Color,
    ..._readonly,
};
/** A (hex) string that represents a color (writeonly) */
const WriteOnlyColor = {
    ...Color,
    ..._writeonly,
};
// Some predefined CC-specific metadata
/** The level of a Switch */
const Level = {
    ...UInt8,
    max: 99,
};
/** The level of a Switch (readonly) */
const ReadOnlyLevel = {
    ...Level,
    ..._readonly,
};
/** The level of a Switch (writeonly) */
const WriteOnlyLevel = {
    ...Level,
    ..._writeonly,
};
/** A duration value */
const _Duration = {
    ..._default,
    type: "duration",
};
/** A duration value (readonly) */
const ReadOnlyDuration = {
    ..._Duration,
    ..._readonly,
};
/** A duration value (writeonly) */
const WriteOnlyDuration = {
    ..._Duration,
    ..._writeonly,
};
/** A buffer */
const _Buffer = {
    ..._default,
    type: "buffer",
};
/** A buffer (readonly) */
const ReadOnlyBuffer = {
    ..._Buffer,
    ..._readonly,
};
/** A buffer (writeonly) */
const WriteOnlyBuffer = {
    ..._Buffer,
    ..._writeonly,
};
/** A collection of predefined CC value metadata */
exports.ValueMetadata = {
    /** The default value for metadata: readable and writeable */
    Any: Object.freeze(Any),
    /** The default value for readonly metadata */
    ReadOnly: Object.freeze(ReadOnly),
    /** The default value for writeonly metadata */
    WriteOnly: Object.freeze(WriteOnly),
    /** A numeric value */
    Number: Object.freeze(Number),
    /** A numeric value (readonly) */
    ReadOnlyNumber: Object.freeze(ReadOnlyNumber),
    /** A numeric value (writeonly) */
    WriteOnlyNumber: Object.freeze(WriteOnlyNumber),
    /** Unsigned 8-bit integer */
    UInt8: Object.freeze(UInt8),
    /** Unsigned 16-bit integer */
    UInt16: Object.freeze(UInt16),
    /** Unsigned 24-bit integer */
    UInt24: Object.freeze(UInt24),
    /** Unsigned 32-bit integer */
    UInt32: Object.freeze(UInt32),
    /** Signed 8-bit integer */
    Int8: Object.freeze(Int8),
    /** Signed 16-bit integer */
    Int16: Object.freeze(Int16),
    /** Signed 24-bit integer */
    Int24: Object.freeze(Int24),
    /** Signed 32-bit integer */
    Int32: Object.freeze(Int32),
    /** Unsigned 8-bit integer (readonly) */
    ReadOnlyUInt8: Object.freeze(ReadOnlyUInt8),
    /** Unsigned 16-bit integer (readonly) */
    ReadOnlyUInt16: Object.freeze(ReadOnlyUInt16),
    /** Unsigned 24-bit integer (readonly) */
    ReadOnlyUInt24: Object.freeze(ReadOnlyUInt24),
    /** Unsigned 32-bit integer (readonly) */
    ReadOnlyUInt32: Object.freeze(ReadOnlyUInt32),
    /** Signed 8-bit integer (readonly) */
    ReadOnlyInt8: Object.freeze(ReadOnlyInt8),
    /** Signed 16-bit integer (readonly) */
    ReadOnlyInt16: Object.freeze(ReadOnlyInt16),
    /** Signed 24-bit integer (readonly) */
    ReadOnlyInt24: Object.freeze(ReadOnlyInt24),
    /** Signed 32-bit integer (readonly) */
    ReadOnlyInt32: Object.freeze(ReadOnlyInt32),
    /** Unsigned 8-bit integer (writeonly) */
    WriteOnlyUInt8: Object.freeze(WriteOnlyUInt8),
    /** Unsigned 16-bit integer (writeonly) */
    WriteOnlyUInt16: Object.freeze(WriteOnlyUInt16),
    /** Unsigned 24-bit integer (writeonly) */
    WriteOnlyUInt24: Object.freeze(WriteOnlyUInt24),
    /** Unsigned 32-bit integer (writeonly) */
    WriteOnlyUInt32: Object.freeze(WriteOnlyUInt32),
    /** Signed 8-bit integer (writeonly) */
    WriteOnlyInt8: Object.freeze(WriteOnlyInt8),
    /** Signed 16-bit integer (writeonly) */
    WriteOnlyInt16: Object.freeze(WriteOnlyInt16),
    /** Signed 24-bit integer (writeonly) */
    WriteOnlyInt24: Object.freeze(WriteOnlyInt24),
    /** Signed 32-bit integer (writeonly) */
    WriteOnlyInt32: Object.freeze(WriteOnlyInt32),
    /** The level of a Switch (0-99) */
    Level: Object.freeze(Level),
    /** The level of a Switch (0-99, readonly) */
    ReadOnlyLevel: Object.freeze(ReadOnlyLevel),
    /** The level of a Switch (0-99, writeonly) */
    WriteOnlyLevel: Object.freeze(WriteOnlyLevel),
    /** A boolean value */
    Boolean: Object.freeze(Boolean),
    /** A boolean value (readonly) */
    ReadOnlyBoolean: Object.freeze(ReadOnlyBoolean),
    /** A boolean value (writeonly) */
    WriteOnlyBoolean: Object.freeze(WriteOnlyBoolean),
    /** A string */
    String: Object.freeze(String),
    /** A string (readonly) */
    ReadOnlyString: Object.freeze(ReadOnlyString),
    /** A string (writeonly) */
    WriteOnlyString: Object.freeze(WriteOnlyString),
    /** A (hex) string that represents a color */
    Color: Object.freeze(Color),
    /** A (hex) string that represents a color (readonly) */
    ReadOnlyColor: Object.freeze(ReadOnlyColor),
    /** A (hex) string that represents a color (writeonly) */
    WriteOnlyColor: Object.freeze(WriteOnlyColor),
    /** A duration value */
    Duration: Object.freeze(_Duration),
    /** A duration value (readonly) */
    ReadOnlyDuration: Object.freeze(ReadOnlyDuration),
    /** A duration value (writeonly) */
    WriteOnlyDuration: Object.freeze(WriteOnlyDuration),
    /** A buffer */
    Buffer: Object.freeze(_Buffer),
    /** A buffer (readonly) */
    ReadOnlyBuffer: Object.freeze(ReadOnlyBuffer),
    /** A buffer (writeonly) */
    WriteOnlyBuffer: Object.freeze(WriteOnlyBuffer),
};
//# sourceMappingURL=Metadata.js.map