/// <reference types="node" />
/** Object.keys, but with `(keyof T)[]` as the return type */
export declare function keysOf<T>(obj: T): (keyof T)[];
/** Returns a subset of `obj` that contains only the given keys */
export declare function pick<T extends Record<any, any>, K extends keyof T>(obj: T, keys: K[]): Pick<T, K>;
/** Calls the map function of the given array and flattens the result by one level */
export declare function flatMap<U, T extends any[]>(array: T[], callbackfn: (value: T, index: number, array: T[]) => U[]): U[];
export declare function getEnumMemberName(enumeration: unknown, value: number): string;
/** Skips the first n bytes of a buffer and returns the rest */
export declare function skipBytes(buf: Buffer, n: number): Buffer;
//# sourceMappingURL=misc.d.ts.map