/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry, ValueID, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum AlarmSensorCommand {
    Get = 1,
    Report = 2,
    SupportedGet = 3,
    SupportedReport = 4
}
export declare enum AlarmSensorType {
    "General Purpose" = 0,
    Smoke = 1,
    CO = 2,
    CO2 = 3,
    Heat = 4,
    "Water Leak" = 5,
    Any = 255
}
/**
 * @publicAPI
 */
export declare type AlarmSensorValueMetadata = ValueMetadata & {
    ccSpecific: {
        sensorType: AlarmSensorType;
    };
};
export declare function getAlarmSensorStateValueId(endpointIndex: number | undefined, sensorType: AlarmSensorType): ValueID;
export declare function getAlarmSensorSeverityValueId(endpointIndex: number | undefined, sensorType: AlarmSensorType): ValueID;
export declare function getAlarmSensorDurationValueId(endpointIndex: number | undefined, sensorType: AlarmSensorType): ValueID;
export declare function getSupportedSensorTypesValueId(endpointIndex: number): ValueID;
export declare class AlarmSensorCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: AlarmSensorCommand): Maybe<boolean>;
    /**
     * Retrieves the current value from this sensor
     * @param sensorType The (optional) sensor type to retrieve the value for
     */
    get(sensorType?: AlarmSensorType): Promise<Pick<AlarmSensorCCReport, "duration" | "state" | "severity"> | undefined>;
    getSupportedSensorTypes(): Promise<readonly AlarmSensorType[] | undefined>;
}
export declare class AlarmSensorCC extends CommandClass {
    ccCommand: AlarmSensorCommand;
    interview(complete?: boolean): Promise<void>;
    protected createMetadataForSensorType(sensorType: AlarmSensorType): void;
}
export declare class AlarmSensorCCReport extends AlarmSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly sensorType: AlarmSensorType;
    readonly state: boolean;
    readonly severity: number | undefined;
    readonly duration: number | undefined;
    toLogEntry(): MessageOrCCLogEntry;
    persistValues(): boolean;
}
interface AlarmSensorCCGetOptions extends CCCommandOptions {
    sensorType?: AlarmSensorType;
}
export declare class AlarmSensorCCGet extends AlarmSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | AlarmSensorCCGetOptions);
    sensorType: AlarmSensorType;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class AlarmSensorCCSupportedReport extends AlarmSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedSensorTypes;
    get supportedSensorTypes(): readonly AlarmSensorType[];
    persistValues(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class AlarmSensorCCSupportedGet extends AlarmSensorCC {
}
export {};
