/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum CRC16Command {
    CommandEncapsulation = 1
}
export declare class CRC16CCAPI extends CCAPI {
    supportsCommand(_cmd: CRC16Command): Maybe<boolean>;
    sendEncapsulated(encapsulatedCC: CommandClass): Promise<void>;
}
export declare class CRC16CC extends CommandClass {
    ccCommand: CRC16Command;
    /** Encapsulates a command in a CRC-16 CC */
    static encapsulate(driver: Driver, cc: CommandClass): CRC16CCCommandEncapsulation;
}
interface CRC16CCCommandEncapsulationOptions extends CCCommandOptions {
    encapsulated: CommandClass;
}
export declare class CRC16CCCommandEncapsulation extends CRC16CC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CRC16CCCommandEncapsulationOptions);
    encapsulated: CommandClass;
    private readonly headerBuffer;
    serialize(): Buffer;
    protected computeEncapsulationOverhead(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
