/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import { AllOrNone } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum FirmwareUpdateMetaDataCommand {
    MetaDataGet = 1,
    MetaDataReport = 2,
    RequestGet = 3,
    RequestReport = 4,
    Get = 5,
    Report = 6,
    StatusReport = 7,
    ActivationSet = 8,
    ActivationReport = 9,
    PrepareGet = 10,
    PrepareReport = 11
}
export declare enum FirmwareUpdateRequestStatus {
    Error_InvalidManufacturerOrFirmwareID = 0,
    Error_AuthenticationExpected = 1,
    Error_FragmentSizeTooLarge = 2,
    Error_NotUpgradable = 3,
    Error_InvalidHardwareVersion = 4,
    Error_FirmwareUpgradeInProgress = 5,
    Error_BatteryLow = 6,
    OK = 255
}
export declare enum FirmwareUpdateStatus {
    Error_Timeout = -1,
    Error_Checksum = 0,
    Error_TransmissionFailed = 1,
    Error_InvalidManufacturerID = 2,
    Error_InvalidFirmwareID = 3,
    Error_InvalidFirmwareTarget = 4,
    Error_InvalidHeaderInformation = 5,
    Error_InvalidHeaderFormat = 6,
    Error_InsufficientMemory = 7,
    Error_InvalidHardwareVersion = 8,
    OK_WaitingForActivation = 253,
    OK_NoRestart = 254,
    OK_RestartPending = 255
}
export declare enum FirmwareUpdateActivationStatus {
    Error_InvalidFirmware = 0,
    Error_ActivationFailed = 1,
    OK = 255
}
export declare enum FirmwareDownloadStatus {
    Error_InvalidManufacturerOrFirmwareID = 0,
    Error_AuthenticationExpected = 1,
    Error_FragmentSizeTooLarge = 2,
    Error_NotDownloadable = 3,
    Error_InvalidHardwareVersion = 4,
    OK = 255
}
export declare class FirmwareUpdateMetaDataCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: FirmwareUpdateMetaDataCommand): Maybe<boolean>;
    /**
     * Requests information about the current firmware on the device
     */
    getMetaData(): Promise<Pick<FirmwareUpdateMetaDataCCMetaDataReport, "supportsActivation" | "manufacturerId" | "firmwareId" | "checksum" | "firmwareUpgradable" | "maxFragmentSize" | "additionalFirmwareIDs" | "hardwareVersion" | "continuesToFunction"> | undefined>;
    /**
     * Requests the device to start the firmware update process.
     * WARNING: This method may wait up to 60 seconds for a reply.
     */
    requestUpdate(options: FirmwareUpdateMetaDataCCRequestGetOptions): Promise<FirmwareUpdateRequestStatus>;
    /**
     * Sends a fragment of the new firmware to the device
     */
    sendFirmwareFragment(fragmentNumber: number, isLastFragment: boolean, data: Buffer): Promise<void>;
    /** Activates a previously transferred firmware image */
    activateFirmware(options: FirmwareUpdateMetaDataCCActivationSetOptions): Promise<FirmwareUpdateActivationStatus | undefined>;
}
export declare class FirmwareUpdateMetaDataCC extends CommandClass {
    ccCommand: FirmwareUpdateMetaDataCommand;
}
export declare class FirmwareUpdateMetaDataCCMetaDataReport extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly manufacturerId: number;
    readonly firmwareId: number;
    readonly checksum: number;
    readonly firmwareUpgradable: boolean;
    readonly maxFragmentSize?: number;
    readonly additionalFirmwareIDs: readonly number[];
    readonly hardwareVersion?: number;
    readonly continuesToFunction: Maybe<boolean>;
    readonly supportsActivation: Maybe<boolean>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateMetaDataCCMetaDataGet extends FirmwareUpdateMetaDataCC {
}
export declare class FirmwareUpdateMetaDataCCRequestReport extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly status: FirmwareUpdateRequestStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
declare type FirmwareUpdateMetaDataCCRequestGetOptions = {
    manufacturerId: number;
    firmwareId: number;
    checksum: number;
} & AllOrNone<{
    firmwareTarget: number;
    fragmentSize: number;
    activation?: boolean;
    hardwareVersion?: number;
}>;
export declare class FirmwareUpdateMetaDataCCRequestGet extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (FirmwareUpdateMetaDataCCRequestGetOptions & CCCommandOptions));
    manufacturerId: number;
    firmwareId: number;
    checksum: number;
    firmwareTarget?: number;
    fragmentSize?: number;
    activation?: boolean;
    hardwareVersion?: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateMetaDataCCGet extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly numReports: number;
    readonly reportNumber: number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface FirmwareUpdateMetaDataCCReportOptions extends CCCommandOptions {
    isLast: boolean;
    reportNumber: number;
    firmwareData: Buffer;
}
export declare class FirmwareUpdateMetaDataCCReport extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | FirmwareUpdateMetaDataCCReportOptions);
    isLast: boolean;
    reportNumber: number;
    firmwareData: Buffer;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateMetaDataCCStatusReport extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly status: FirmwareUpdateStatus;
    /** The wait time in seconds before the node becomes available for communication after the update */
    readonly waitTime?: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateMetaDataCCActivationReport extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly manufacturerId: number;
    readonly firmwareId: number;
    readonly checksum: number;
    readonly firmwareTarget: number;
    readonly activationStatus: FirmwareUpdateActivationStatus;
    readonly hardwareVersion?: number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface FirmwareUpdateMetaDataCCActivationSetOptions {
    manufacturerId: number;
    firmwareId: number;
    checksum: number;
    firmwareTarget: number;
    hardwareVersion?: number;
}
export declare class FirmwareUpdateMetaDataCCActivationSet extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (FirmwareUpdateMetaDataCCActivationSetOptions & CCCommandOptions));
    manufacturerId: number;
    firmwareId: number;
    checksum: number;
    firmwareTarget: number;
    hardwareVersion?: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FirmwareUpdateMetaDataCCPrepareReport extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly status: FirmwareDownloadStatus;
    readonly checksum: number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface FirmwareUpdateMetaDataCCPrepareGetOptions extends CCCommandOptions {
    manufacturerId: number;
    firmwareId: number;
    firmwareTarget: number;
    fragmentSize: number;
    hardwareVersion: number;
}
export declare class FirmwareUpdateMetaDataCCPrepareGet extends FirmwareUpdateMetaDataCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | FirmwareUpdateMetaDataCCPrepareGetOptions);
    manufacturerId: number;
    firmwareId: number;
    firmwareTarget: number;
    fragmentSize: number;
    hardwareVersion: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
