"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockCCGet = exports.LockCCReport = exports.LockCCSet = exports.LockCC = exports.LockCCAPI = exports.getLockedValueId = exports.LockCommand = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var LockCommand;
(function (LockCommand) {
    LockCommand[LockCommand["Set"] = 1] = "Set";
    LockCommand[LockCommand["Get"] = 2] = "Get";
    LockCommand[LockCommand["Report"] = 3] = "Report";
})(LockCommand = exports.LockCommand || (exports.LockCommand = {}));
function getLockedValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Lock,
        endpoint,
        property: "locked",
    };
}
exports.getLockedValueId = getLockedValueId;
let LockCCAPI = class LockCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            if (property !== "locked") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "boolean") {
                API_1.throwWrongValueType(this.ccId, property, "boolean", typeof value);
            }
            await this.set(value);
            // Verify the current value after a delay
            this.schedulePoll({ property });
        };
        this[_b] = async ({ property, }) => {
            if (property === "locked")
                return this.get();
            API_1.throwUnsupportedProperty(this.ccId, property);
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case LockCommand.Get:
            case LockCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async get() {
        this.assertSupportsCommand(LockCommand, LockCommand.Get);
        const cc = new LockCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.locked;
    }
    /**
     * Locks or unlocks the lock
     * @param locked Whether the lock should be locked
     */
    async set(locked) {
        this.assertSupportsCommand(LockCommand, LockCommand.Set);
        const cc = new LockCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            locked,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
LockCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Lock)
], LockCCAPI);
exports.LockCCAPI = LockCCAPI;
let LockCC = class LockCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Lock.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "requesting current lock state...",
            direction: "outbound",
        });
        const locked = await api.get();
        const logMessage = `the lock is ${locked ? "locked" : "unlocked"}`;
        this.driver.controllerLog.logNode(node.id, {
            message: logMessage,
            direction: "inbound",
        });
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
LockCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Lock),
    CommandClass_1.implementedVersion(1)
], LockCC);
exports.LockCC = LockCC;
let LockCCSet = class LockCCSet extends LockCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.locked = options.locked;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.locked ? 1 : 0]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { locked: this.locked },
        };
    }
};
LockCCSet = __decorate([
    CommandClass_1.CCCommand(LockCommand.Set)
], LockCCSet);
exports.LockCCSet = LockCCSet;
let LockCCReport = class LockCCReport extends LockCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.locked = this.payload[0] === 1;
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { locked: this.locked },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Boolean,
        label: "Locked",
        description: "Whether the lock is locked",
    })
], LockCCReport.prototype, "locked", void 0);
LockCCReport = __decorate([
    CommandClass_1.CCCommand(LockCommand.Report)
], LockCCReport);
exports.LockCCReport = LockCCReport;
let LockCCGet = class LockCCGet extends LockCC {
};
LockCCGet = __decorate([
    CommandClass_1.CCCommand(LockCommand.Get),
    CommandClass_1.expectedCCResponse(LockCCReport)
], LockCCGet);
exports.LockCCGet = LockCCGet;

//# sourceMappingURL=LockCC.js.map
