/// <reference types="node" />
import { Duration, Maybe, MessageOrCCLogEntry, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions, CommandClassOptions } from "./CommandClass";
export declare enum MultilevelSwitchCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    StartLevelChange = 4,
    StopLevelChange = 5,
    SupportedGet = 6,
    SupportedReport = 7
}
/**
 * @publicAPI
 */
export declare enum LevelChangeDirection {
    "up" = 0,
    "down" = 1
}
/**
 * @publicAPI
 */
export declare enum SwitchType {
    "not supported" = 0,
    "Off/On" = 1,
    "Down/Up" = 2,
    "Close/Open" = 3,
    "CCW/CW" = 4,
    "Left/Right" = 5,
    "Reverse/Forward" = 6,
    "Pull/Push" = 7
}
/**
 * @publicAPI
 */
export declare type MultilevelSwitchLevelChangeMetadata = ValueMetadata & {
    ccSpecific: {
        switchType: SwitchType;
    };
};
export declare class MultilevelSwitchCCAPI extends CCAPI {
    supportsCommand(cmd: MultilevelSwitchCommand): Maybe<boolean>;
    get(): Promise<Pick<MultilevelSwitchCCReport, "targetValue" | "currentValue" | "duration"> | undefined>;
    private refreshTimeout;
    /**
     * Sets the switch to a new value
     * @param targetValue The new target value for the switch
     * @param duration The optional duration to reach the target value. Available in V2+
     * @returns A promise indicating whether the command was completed
     */
    set(targetValue: number, duration?: Duration): Promise<boolean>;
    startLevelChange(options: MultilevelSwitchCCStartLevelChangeOptions): Promise<void>;
    stopLevelChange(): Promise<void>;
    getSupported(): Promise<SwitchType | undefined>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class MultilevelSwitchCC extends CommandClass {
    ccCommand: MultilevelSwitchCommand;
    constructor(driver: Driver, options: CommandClassOptions);
    interview(complete?: boolean): Promise<void>;
    setMappedBasicValue(value: number): boolean;
    protected createMetadataForLevelChangeActions(switchType?: SwitchType): void;
}
interface MultilevelSwitchCCSetOptions extends CCCommandOptions {
    targetValue: number;
    duration?: Duration;
}
export declare class MultilevelSwitchCCSet extends MultilevelSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultilevelSwitchCCSetOptions);
    targetValue: number;
    duration: Duration | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultilevelSwitchCCReport extends MultilevelSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly targetValue: number | undefined;
    readonly duration: Duration | undefined;
    readonly currentValue: Maybe<number> | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultilevelSwitchCCGet extends MultilevelSwitchCC {
}
declare type MultilevelSwitchCCStartLevelChangeOptions = {
    direction: keyof typeof LevelChangeDirection;
} & ({
    ignoreStartLevel: true;
    startLevel?: number;
} | {
    ignoreStartLevel: false;
    startLevel: number;
}) & {
    duration?: Duration;
};
export declare class MultilevelSwitchCCStartLevelChange extends MultilevelSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (CCCommandOptions & MultilevelSwitchCCStartLevelChangeOptions));
    duration: Duration | undefined;
    startLevel: number;
    ignoreStartLevel: boolean;
    direction: keyof typeof LevelChangeDirection;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultilevelSwitchCCStopLevelChange extends MultilevelSwitchCC {
}
export declare class MultilevelSwitchCCSupportedReport extends MultilevelSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _switchType;
    get switchType(): SwitchType;
    persistValues(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultilevelSwitchCCSupportedGet extends MultilevelSwitchCC {
}
export {};
