/// <reference types="node" />
import { CommandClasses, Duration, Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum SceneControllerConfigurationCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare function getSceneIdValueID(endpoint: number | undefined, groupId: number): ValueID;
export declare function getDimmingDurationValueID(endpoint: number | undefined, groupId: number): ValueID;
export declare class SceneControllerConfigurationCCAPI extends CCAPI {
    supportsCommand(cmd: SceneControllerConfigurationCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    disable(groupId: number): Promise<void>;
    set(groupId: number, sceneId: number, dimmingDuration: Duration): Promise<void>;
    getLastActivated(): Promise<Pick<SceneControllerConfigurationCCReport, "groupId" | "sceneId" | "dimmingDuration"> | undefined>;
    get(groupId: number): Promise<Pick<SceneControllerConfigurationCCReport, "sceneId" | "dimmingDuration"> | undefined>;
}
export declare class SceneControllerConfigurationCC extends CommandClass {
    ccCommand: SceneControllerConfigurationCommand;
    determineRequiredCCInterviews(): readonly CommandClasses[];
    interview(complete?: boolean): Promise<void>;
    /**
     * Returns the number of association groups reported by the node.
     * This only works AFTER the node has been interviewed by this CC
     * or the AssociationCC.
     */
    protected getGroupCountCached(): number;
}
interface SceneControllerConfigurationCCSetOptions extends CCCommandOptions {
    groupId: number;
    sceneId: number;
    dimmingDuration: Duration;
}
export declare class SceneControllerConfigurationCCSet extends SceneControllerConfigurationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SceneControllerConfigurationCCSetOptions);
    groupId: number;
    sceneId: number;
    dimmingDuration: Duration;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SceneControllerConfigurationCCReport extends SceneControllerConfigurationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly groupId: number;
    readonly sceneId: number;
    readonly dimmingDuration: Duration;
    persistValues(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
interface SceneControllerConfigurationCCGetOptions extends CCCommandOptions {
    groupId: number;
}
export declare class SceneControllerConfigurationCCGet extends SceneControllerConfigurationCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SceneControllerConfigurationCCGetOptions);
    groupId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
