"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SceneControllerConfigurationCCGet = exports.SceneControllerConfigurationCCReport = exports.SceneControllerConfigurationCCSet = exports.SceneControllerConfigurationCC = exports.SceneControllerConfigurationCCAPI = exports.getDimmingDurationValueID = exports.getSceneIdValueID = exports.SceneControllerConfigurationCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var SceneControllerConfigurationCommand;
(function (SceneControllerConfigurationCommand) {
    SceneControllerConfigurationCommand[SceneControllerConfigurationCommand["Set"] = 1] = "Set";
    SceneControllerConfigurationCommand[SceneControllerConfigurationCommand["Get"] = 2] = "Get";
    SceneControllerConfigurationCommand[SceneControllerConfigurationCommand["Report"] = 3] = "Report";
})(SceneControllerConfigurationCommand = exports.SceneControllerConfigurationCommand || (exports.SceneControllerConfigurationCommand = {}));
function getSceneIdValueID(endpoint, groupId) {
    return {
        commandClass: core_1.CommandClasses["Scene Controller Configuration"],
        endpoint,
        property: "sceneId",
        propertyKey: groupId,
    };
}
exports.getSceneIdValueID = getSceneIdValueID;
function getDimmingDurationValueID(endpoint, groupId) {
    return {
        commandClass: core_1.CommandClasses["Scene Controller Configuration"],
        endpoint,
        property: "dimmingDuration",
        propertyKey: groupId,
    };
}
exports.getDimmingDurationValueID = getDimmingDurationValueID;
function persistSceneConfig(groupId, sceneId, dimmingDuration) {
    const sceneIdValueId = getSceneIdValueID(this.endpointIndex, groupId);
    const dimmingDurationValueId = getDimmingDurationValueID(this.endpointIndex, groupId);
    const valueDB = this.getValueDB();
    if (!valueDB.hasMetadata(sceneIdValueId)) {
        valueDB.setMetadata(sceneIdValueId, {
            ...core_1.ValueMetadata.UInt8,
            label: `Associated Scene ID (${groupId})`,
        });
    }
    if (!valueDB.hasMetadata(dimmingDurationValueId)) {
        valueDB.setMetadata(dimmingDurationValueId, {
            ...core_1.ValueMetadata.Duration,
            label: `Dimming duration (${groupId})`,
        });
    }
    valueDB.setValue(sceneIdValueId, sceneId);
    valueDB.setValue(dimmingDurationValueId, dimmingDuration);
    return true;
}
let SceneControllerConfigurationCCAPI = class SceneControllerConfigurationCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            var _c;
            if (propertyKey == undefined) {
                API_1.throwMissingPropertyKey(this.ccId, property);
            }
            else if (typeof propertyKey !== "number") {
                API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
            }
            if (property === "sceneId") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                if (value === 0) {
                    // Disable Group ID / Scene ID
                    await this.disable(propertyKey);
                }
                else {
                    // We need to set the dimming duration along with the scene ID
                    const node = this.endpoint.getNodeUnsafe();
                    // If duration is missing, we set a default of instant
                    const dimmingDuration = (_c = node.getValue(getDimmingDurationValueID(this.endpoint.index, propertyKey))) !== null && _c !== void 0 ? _c : new core_1.Duration(0, "seconds");
                    await this.set(propertyKey, value, dimmingDuration);
                }
            }
            else {
                // setting dimmingDuration value alone not supported,
                // because I'm not sure how to handle a Duration value
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, propertyKey, }) => {
            var _c;
            switch (property) {
                case "sceneId":
                case "dimmingDuration": {
                    if (propertyKey == undefined) {
                        API_1.throwMissingPropertyKey(this.ccId, property);
                    }
                    else if (typeof propertyKey !== "number") {
                        API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                    }
                    return (_c = (await this.get(propertyKey))) === null || _c === void 0 ? void 0 : _c[property];
                }
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case SceneControllerConfigurationCommand.Get:
                return this.isSinglecast();
            case SceneControllerConfigurationCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async disable(groupId) {
        this.assertSupportsCommand(SceneControllerConfigurationCommand, SceneControllerConfigurationCommand.Set);
        return this.set(groupId, 0, new core_1.Duration(0, "seconds"));
    }
    async set(groupId, sceneId, dimmingDuration) {
        this.assertSupportsCommand(SceneControllerConfigurationCommand, SceneControllerConfigurationCommand.Set);
        const cc = new SceneControllerConfigurationCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId,
            sceneId,
            dimmingDuration,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getLastActivated() {
        this.assertSupportsCommand(SceneControllerConfigurationCommand, SceneControllerConfigurationCommand.Get);
        const cc = new SceneControllerConfigurationCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId: 0,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        // Return value includes "groupId", because
        // the returned report will include the actual groupId of the
        // last activated groupId / sceneId
        if (response) {
            return shared_1.pick(response, ["groupId", "sceneId", "dimmingDuration"]);
        }
    }
    async get(groupId) {
        this.assertSupportsCommand(SceneControllerConfigurationCommand, SceneControllerConfigurationCommand.Get);
        if (groupId === 0) {
            throw new core_1.ZWaveError(`Invalid group ID 0. To get the last activated group / scene, use getLastActivated() instead.`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        const cc = new SceneControllerConfigurationCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            groupId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        // Since groupId is not allowed to be 0, only Reports with
        // groupId equal to the requested groupId will be accepted,
        // so we can omit groupId from the return.
        if (response) {
            return shared_1.pick(response, ["sceneId", "dimmingDuration"]);
        }
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
SceneControllerConfigurationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Scene Controller Configuration"])
], SceneControllerConfigurationCCAPI);
exports.SceneControllerConfigurationCCAPI = SceneControllerConfigurationCCAPI;
let SceneControllerConfigurationCC = class SceneControllerConfigurationCC extends CommandClass_1.CommandClass {
    determineRequiredCCInterviews() {
        // AssociationCC is required and MUST be interviewed
        // before SceneControllerConfigurationCC to supply groupCount
        return [
            ...super.determineRequiredCCInterviews(),
            core_1.CommandClasses.Association,
        ];
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Scene Controller Configuration"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        const groupCount = this.getGroupCountCached();
        if (groupCount === 0) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `skipping Scene Controller Configuration interview because Association group count is unknown`,
                direction: "none",
                level: "warn",
            });
            return;
        }
        // Always query scene configuration for each association group
        for (let groupId = 1; groupId <= groupCount; groupId++) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `querying scene configuration for association group #${groupId}...`,
                direction: "outbound",
            });
            const group = await api.get(groupId);
            if (group != undefined) {
                const logMessage = `received scene configuration for association group #${groupId}:
scene ID:         ${group.sceneId}
dimming duration: ${group.dimmingDuration.toString()}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    /**
     * Returns the number of association groups reported by the node.
     * This only works AFTER the node has been interviewed by this CC
     * or the AssociationCC.
     */
    getGroupCountCached() {
        var _c, _d, _e;
        return ((_e = (_d = (_c = this.getEndpoint()) === null || _c === void 0 ? void 0 : _c.createCCInstanceUnsafe(core_1.CommandClasses.Association)) === null || _d === void 0 ? void 0 : _d.getGroupCountCached()) !== null && _e !== void 0 ? _e : 0);
    }
};
SceneControllerConfigurationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Scene Controller Configuration"]),
    CommandClass_1.implementedVersion(1)
], SceneControllerConfigurationCC);
exports.SceneControllerConfigurationCC = SceneControllerConfigurationCC;
let SceneControllerConfigurationCCSet = class SceneControllerConfigurationCCSet extends SceneControllerConfigurationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            const groupCount = this.getGroupCountCached();
            this.groupId = options.groupId;
            this.sceneId = options.sceneId;
            this.dimmingDuration = options.dimmingDuration;
            // The client SHOULD NOT specify group 1 (the life-line group).
            // We don't block it here, because the specs don't forbid it,
            // and it may be needed for some devices.
            if (this.groupId < 1 || this.groupId > groupCount) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The group ID must be between 1 and the number of supported groups ${groupCount}.`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
        }
    }
    serialize() {
        this.payload = Buffer.from([
            this.groupId,
            this.sceneId,
            this.dimmingDuration.serializeSet(),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                "scene id": this.sceneId,
                "dimming duration": this.dimmingDuration.toString(),
            },
        };
    }
};
SceneControllerConfigurationCCSet = __decorate([
    CommandClass_1.CCCommand(SceneControllerConfigurationCommand.Set)
], SceneControllerConfigurationCCSet);
exports.SceneControllerConfigurationCCSet = SceneControllerConfigurationCCSet;
let SceneControllerConfigurationCCReport = class SceneControllerConfigurationCCReport extends SceneControllerConfigurationCC {
    constructor(driver, options) {
        var _c;
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 3);
        this.groupId = this.payload[0];
        this.sceneId = this.payload[1];
        this.dimmingDuration =
            (_c = core_1.Duration.parseReport(this.payload[2])) !== null && _c !== void 0 ? _c : new core_1.Duration(0, "unknown");
        this.persistValues();
    }
    persistValues() {
        // If groupId = 0, values are meaningless
        if (this.groupId === 0)
            return false;
        return persistSceneConfig.call(this, this.groupId, this.sceneId, this.dimmingDuration);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "group id": this.groupId,
                "scene id": this.sceneId,
                "dimming duration": this.dimmingDuration.toString(),
            },
        };
    }
};
SceneControllerConfigurationCCReport = __decorate([
    CommandClass_1.CCCommand(SceneControllerConfigurationCommand.Report)
], SceneControllerConfigurationCCReport);
exports.SceneControllerConfigurationCCReport = SceneControllerConfigurationCCReport;
function testResponseForSceneControllerConfigurationGet(sent, received) {
    // We expect a Scene Controller Configuration Report that matches
    // the requested groupId, unless groupId 0 was requested
    return sent.groupId === 0 || received.groupId === sent.groupId;
}
let SceneControllerConfigurationCCGet = class SceneControllerConfigurationCCGet extends SceneControllerConfigurationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            const groupCount = this.getGroupCountCached();
            if (options.groupId < 0 || options.groupId > groupCount) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The group ID must be between 0 and the number of supported groups ${groupCount}.`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.groupId = options.groupId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.groupId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "group id": this.groupId },
        };
    }
};
SceneControllerConfigurationCCGet = __decorate([
    CommandClass_1.CCCommand(SceneControllerConfigurationCommand.Get),
    CommandClass_1.expectedCCResponse(SceneControllerConfigurationCCReport, testResponseForSceneControllerConfigurationGet)
], SceneControllerConfigurationCCGet);
exports.SceneControllerConfigurationCCGet = SceneControllerConfigurationCCGet;

//# sourceMappingURL=SceneControllerConfigurationCC.js.map
