"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SoundSwitchCCTonePlayGet = exports.SoundSwitchCCTonePlayReport = exports.SoundSwitchCCTonePlaySet = exports.SoundSwitchCCConfigurationGet = exports.SoundSwitchCCConfigurationReport = exports.SoundSwitchCCConfigurationSet = exports.SoundSwitchCCToneInfoGet = exports.SoundSwitchCCToneInfoReport = exports.SoundSwitchCCTonesNumberGet = exports.SoundSwitchCCTonesNumberReport = exports.SoundSwitchCC = exports.SoundSwitchCCAPI = exports.ToneId = exports.SoundSwitchCommand = exports.getToneIdValueId = exports.getVolumeValueId = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const math_1 = require("alcalzone-shared/math");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
function getVolumeValueId(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Sound Switch"],
        endpoint: endpointIndex,
        property: "volume",
    };
}
exports.getVolumeValueId = getVolumeValueId;
function getToneIdValueId(endpointIndex) {
    return {
        commandClass: core_1.CommandClasses["Sound Switch"],
        endpoint: endpointIndex,
        property: "toneId",
    };
}
exports.getToneIdValueId = getToneIdValueId;
// All the supported commands
var SoundSwitchCommand;
(function (SoundSwitchCommand) {
    SoundSwitchCommand[SoundSwitchCommand["TonesNumberGet"] = 1] = "TonesNumberGet";
    SoundSwitchCommand[SoundSwitchCommand["TonesNumberReport"] = 2] = "TonesNumberReport";
    SoundSwitchCommand[SoundSwitchCommand["ToneInfoGet"] = 3] = "ToneInfoGet";
    SoundSwitchCommand[SoundSwitchCommand["ToneInfoReport"] = 4] = "ToneInfoReport";
    SoundSwitchCommand[SoundSwitchCommand["ConfigurationSet"] = 5] = "ConfigurationSet";
    SoundSwitchCommand[SoundSwitchCommand["ConfigurationGet"] = 6] = "ConfigurationGet";
    SoundSwitchCommand[SoundSwitchCommand["ConfigurationReport"] = 7] = "ConfigurationReport";
    SoundSwitchCommand[SoundSwitchCommand["TonePlaySet"] = 8] = "TonePlaySet";
    SoundSwitchCommand[SoundSwitchCommand["TonePlayGet"] = 9] = "TonePlayGet";
    SoundSwitchCommand[SoundSwitchCommand["TonePlayReport"] = 10] = "TonePlayReport";
})(SoundSwitchCommand = exports.SoundSwitchCommand || (exports.SoundSwitchCommand = {}));
// @publicAPI
var ToneId;
(function (ToneId) {
    ToneId[ToneId["Off"] = 0] = "Off";
    ToneId[ToneId["Default"] = 255] = "Default";
})(ToneId = exports.ToneId || (exports.ToneId = {}));
let SoundSwitchCCAPI = class SoundSwitchCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            var _c;
            if (property === "defaultToneId") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.setConfiguration(value, 0xff /* keep current volume */);
            }
            else if (property === "defaultVolume") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.setConfiguration(0x00 /* keep current tone */, value);
            }
            else if (property === "toneId") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                if (value > 0) {
                    // Try to use the current volume if it exists
                    const volume = (_c = this.endpoint
                        .getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.getValue(getVolumeValueId(this.endpoint.index));
                    await this.play(value, volume);
                }
                else {
                    await this.stopPlaying();
                }
                if (this.isSinglecast()) {
                    // Verify the current value after a delay
                    this.schedulePoll({ property });
                }
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, }) => {
            var _c, _d;
            switch (property) {
                case "defaultToneId":
                case "defaultVolume":
                    return (_c = (await this.getConfiguration())) === null || _c === void 0 ? void 0 : _c[property];
                case "toneId":
                case "volume":
                    return (_d = (await this.getPlaying())) === null || _d === void 0 ? void 0 : _d[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case SoundSwitchCommand.TonesNumberGet:
            case SoundSwitchCommand.ToneInfoGet:
            case SoundSwitchCommand.ConfigurationGet:
            case SoundSwitchCommand.TonePlayGet:
                return this.isSinglecast();
            case SoundSwitchCommand.ConfigurationSet:
            case SoundSwitchCommand.TonePlaySet:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async getToneCount() {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.TonesNumberGet);
        const cc = new SoundSwitchCCTonesNumberGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.toneCount;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getToneInfo(toneId) {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.ToneInfoGet);
        const cc = new SoundSwitchCCToneInfoGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            toneId,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response)
            return shared_1.pick(response, ["duration", "name"]);
    }
    async setConfiguration(defaultToneId, defaultVolume) {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.ConfigurationSet);
        const cc = new SoundSwitchCCConfigurationSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            defaultToneId,
            defaultVolume,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getConfiguration() {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.ConfigurationGet);
        const cc = new SoundSwitchCCConfigurationGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["defaultToneId", "defaultVolume"]);
        }
    }
    async play(toneId, volume) {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.TonePlaySet);
        if (toneId === 0) {
            throw new core_1.ZWaveError(`Tone ID must be > 0. Use stopPlaying to stop the tone.`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        const cc = new SoundSwitchCCTonePlaySet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            toneId,
            volume,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async stopPlaying() {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.TonePlaySet);
        const cc = new SoundSwitchCCTonePlaySet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            toneId: 0x00,
            volume: 0x00,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getPlaying() {
        this.assertSupportsCommand(SoundSwitchCommand, SoundSwitchCommand.TonePlayGet);
        const cc = new SoundSwitchCCTonePlayGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["toneId", "volume"]);
        }
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
SoundSwitchCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Sound Switch"])
], SoundSwitchCCAPI);
exports.SoundSwitchCCAPI = SoundSwitchCCAPI;
let SoundSwitchCC = class SoundSwitchCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Sound Switch"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "requesting current sound configuration...",
            direction: "outbound",
        });
        const config = await api.getConfiguration();
        if (config) {
            const logMessage = `received current sound configuration:
default tone ID: ${config.defaultToneId}
default volume: ${config.defaultVolume}`;
            this.driver.controllerLog.logNode(node.id, {
                message: logMessage,
                direction: "inbound",
            });
        }
        if (complete) {
            this.driver.controllerLog.logNode(node.id, {
                message: "requesting tone count...",
                direction: "outbound",
            });
            const toneCount = await api.getToneCount();
            if (toneCount != undefined) {
                const logMessage = `supports ${toneCount} tones`;
                this.driver.controllerLog.logNode(node.id, {
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying tone count timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
            const metadataStates = {
                0: "off",
            };
            for (let toneId = 1; toneId <= toneCount; toneId++) {
                this.driver.controllerLog.logNode(node.id, {
                    message: `requesting info for tone #${toneId}`,
                    direction: "outbound",
                });
                const info = await api.getToneInfo(toneId);
                if (!info)
                    continue;
                const logMessage = `received info for tone #${toneId}:
name:     ${info.name}
duration: ${info.duration} seconds`;
                this.driver.controllerLog.logNode(node.id, {
                    message: logMessage,
                    direction: "inbound",
                });
                metadataStates[toneId] = `${info.name} (${info.duration} sec)`;
            }
            metadataStates[0xff] = "default";
            // Store tone count and info as a single metadata
            node.valueDB.setMetadata(getToneIdValueId(this.endpointIndex), {
                ...core_1.ValueMetadata.Number,
                min: 0,
                max: toneCount,
                states: metadataStates,
                label: "Play Tone",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
SoundSwitchCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Sound Switch"]),
    CommandClass_1.implementedVersion(2)
], SoundSwitchCC);
exports.SoundSwitchCC = SoundSwitchCC;
let SoundSwitchCCTonesNumberReport = class SoundSwitchCCTonesNumberReport extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.toneCount = this.payload[0];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "# of tones": this.toneCount },
        };
    }
};
SoundSwitchCCTonesNumberReport = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.TonesNumberReport)
], SoundSwitchCCTonesNumberReport);
exports.SoundSwitchCCTonesNumberReport = SoundSwitchCCTonesNumberReport;
let SoundSwitchCCTonesNumberGet = class SoundSwitchCCTonesNumberGet extends SoundSwitchCC {
};
SoundSwitchCCTonesNumberGet = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.TonesNumberGet),
    CommandClass_1.expectedCCResponse(SoundSwitchCCTonesNumberReport)
], SoundSwitchCCTonesNumberGet);
exports.SoundSwitchCCTonesNumberGet = SoundSwitchCCTonesNumberGet;
let SoundSwitchCCToneInfoReport = class SoundSwitchCCToneInfoReport extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 4);
        this.toneId = this.payload[0];
        this.duration = this.payload.readUInt16BE(1);
        const nameLength = this.payload[3];
        core_1.validatePayload(this.payload.length >= 4 + nameLength);
        this.name = this.payload.slice(4, 4 + nameLength).toString("utf8");
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "tone id": this.toneId,
                duration: `${this.duration} seconds`,
                name: this.name,
            },
        };
    }
};
SoundSwitchCCToneInfoReport = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.ToneInfoReport)
], SoundSwitchCCToneInfoReport);
exports.SoundSwitchCCToneInfoReport = SoundSwitchCCToneInfoReport;
const testResponseForSoundSwitchToneInfoGet = (sent, received) => {
    return received.toneId === sent.toneId;
};
let SoundSwitchCCToneInfoGet = class SoundSwitchCCToneInfoGet extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.toneId = options.toneId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.toneId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "tone id": this.toneId },
        };
    }
};
SoundSwitchCCToneInfoGet = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.ToneInfoGet),
    CommandClass_1.expectedCCResponse(SoundSwitchCCToneInfoReport, testResponseForSoundSwitchToneInfoGet)
], SoundSwitchCCToneInfoGet);
exports.SoundSwitchCCToneInfoGet = SoundSwitchCCToneInfoGet;
let SoundSwitchCCConfigurationSet = class SoundSwitchCCConfigurationSet extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.defaultVolume = options.defaultVolume;
            this.defaultToneId = options.defaultToneId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.defaultVolume, this.defaultToneId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "default volume": `${this.defaultVolume} %`,
                "default tone id": this.defaultToneId,
            },
        };
    }
};
SoundSwitchCCConfigurationSet = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.ConfigurationSet)
], SoundSwitchCCConfigurationSet);
exports.SoundSwitchCCConfigurationSet = SoundSwitchCCConfigurationSet;
let SoundSwitchCCConfigurationReport = class SoundSwitchCCConfigurationReport extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.defaultVolume = math_1.clamp(this.payload[0], 0, 100);
        this.defaultToneId = this.payload[1];
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "default volume": `${this.defaultVolume} %`,
                "default tone id": this.defaultToneId,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Number,
        min: 0,
        max: 100,
        unit: "%",
        label: "Default volume",
    })
], SoundSwitchCCConfigurationReport.prototype, "defaultVolume", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Number,
        min: 0,
        max: 254,
        label: "Default tone ID",
    })
], SoundSwitchCCConfigurationReport.prototype, "defaultToneId", void 0);
SoundSwitchCCConfigurationReport = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.ConfigurationReport)
], SoundSwitchCCConfigurationReport);
exports.SoundSwitchCCConfigurationReport = SoundSwitchCCConfigurationReport;
let SoundSwitchCCConfigurationGet = class SoundSwitchCCConfigurationGet extends SoundSwitchCC {
};
SoundSwitchCCConfigurationGet = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.ConfigurationGet),
    CommandClass_1.expectedCCResponse(SoundSwitchCCConfigurationReport)
], SoundSwitchCCConfigurationGet);
exports.SoundSwitchCCConfigurationGet = SoundSwitchCCConfigurationGet;
let SoundSwitchCCTonePlaySet = class SoundSwitchCCTonePlaySet extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.toneId = options.toneId;
            this.volume = options.volume;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.toneId]);
        if (this.version >= 2 && this.volume != undefined) {
            this.payload = Buffer.concat([
                this.payload,
                Buffer.from([this.volume]),
            ]);
        }
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "tone id": this.toneId,
        };
        if (this.volume != undefined) {
            message.volume = this.volume === 0 ? "default" : `${this.volume} %`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
SoundSwitchCCTonePlaySet = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.TonePlaySet)
], SoundSwitchCCTonePlaySet);
exports.SoundSwitchCCTonePlaySet = SoundSwitchCCTonePlaySet;
let SoundSwitchCCTonePlayReport = class SoundSwitchCCTonePlayReport extends SoundSwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.toneId = this.payload[0];
        if (this.toneId !== 0 && this.payload.length >= 2) {
            this.volume = this.payload[1];
        }
        this.persistValues();
    }
    toLogEntry() {
        const message = {
            "tone id": this.toneId,
        };
        if (this.volume != undefined) {
            message.volume = this.volume === 0 ? "default" : `${this.volume} %`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        label: "Tone ID",
    })
], SoundSwitchCCTonePlayReport.prototype, "toneId", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        min: 0,
        max: 100,
        unit: "%",
        label: "Volume",
        states: {
            0: "default",
        },
    })
], SoundSwitchCCTonePlayReport.prototype, "volume", void 0);
SoundSwitchCCTonePlayReport = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.TonePlayReport)
], SoundSwitchCCTonePlayReport);
exports.SoundSwitchCCTonePlayReport = SoundSwitchCCTonePlayReport;
let SoundSwitchCCTonePlayGet = class SoundSwitchCCTonePlayGet extends SoundSwitchCC {
};
SoundSwitchCCTonePlayGet = __decorate([
    CommandClass_1.CCCommand(SoundSwitchCommand.TonePlayGet),
    CommandClass_1.expectedCCResponse(SoundSwitchCCTonePlayReport)
], SoundSwitchCCTonePlayGet);
exports.SoundSwitchCCTonePlayGet = SoundSwitchCCTonePlayGet;

//# sourceMappingURL=SoundSwitchCC.js.map
