/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ThermostatFanModeCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    SupportedGet = 4,
    SupportedReport = 5
}
/**
 * @publicAPI
 */
export declare enum ThermostatFanMode {
    "Auto low" = 0,
    "Low" = 1,
    "Auto high" = 2,
    "High" = 3,
    "Auto medium" = 4,
    "Medium" = 5,
    "Circulation" = 6,
    "Humidity circulation" = 7,
    "Left and right" = 8,
    "Up and down" = 9,
    "Quiet" = 10,
    "External circulation" = 11
}
export declare function getOffStateValueID(endpoint: number): ValueID;
export declare function getModeStateValueID(endpoint: number): ValueID;
export declare class ThermostatFanModeCCAPI extends CCAPI {
    supportsCommand(cmd: ThermostatFanModeCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Pick<ThermostatFanModeCCReport, "mode" | "off"> | undefined>;
    set(mode: ThermostatFanMode, off?: boolean): Promise<void>;
    getSupportedModes(): Promise<readonly ThermostatFanMode[] | undefined>;
}
export declare class ThermostatFanModeCC extends CommandClass {
    ccCommand: ThermostatFanModeCommand;
    interview(complete?: boolean): Promise<void>;
}
declare type ThermostatFanModeCCSetOptions = CCCommandOptions & {
    mode: ThermostatFanMode;
    off?: boolean;
};
export declare class ThermostatFanModeCCSet extends ThermostatFanModeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ThermostatFanModeCCSetOptions);
    mode: ThermostatFanMode;
    off: boolean | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatFanModeCCReport extends ThermostatFanModeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _mode;
    get mode(): ThermostatFanMode;
    private _off;
    get off(): boolean | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatFanModeCCGet extends ThermostatFanModeCC {
}
export declare class ThermostatFanModeCCSupportedReport extends ThermostatFanModeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedModes;
    get supportedModes(): readonly ThermostatFanMode[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatFanModeCCSupportedGet extends ThermostatFanModeCC {
}
export {};
