import { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE } from "./API";
import { CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ThermostatFanStateCommand {
    Get = 2,
    Report = 3
}
export declare enum ThermostatFanState {
    "Idle / off" = 0,
    "Running / running low" = 1,
    "Running high" = 2,
    "Running medium" = 3,
    "Circulation mode" = 4,
    "Humidity circulation mode" = 5,
    "Right - left circulation mode" = 6,
    "Up - down circulation mode" = 7,
    "Quiet circulation mode" = 8
}
export declare class ThermostatFanStateCCAPI extends CCAPI {
    supportsCommand(cmd: ThermostatFanStateCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<ThermostatFanState | undefined>;
}
export declare class ThermostatFanStateCC extends CommandClass {
    ccCommand: ThermostatFanStateCommand;
    interview(complete?: boolean): Promise<void>;
}
export declare class ThermostatFanStateCCReport extends ThermostatFanStateCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _state;
    get state(): ThermostatFanState;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatFanStateCCGet extends ThermostatFanStateCC {
}
