/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum TimeParametersCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare class TimeParametersCCAPI extends CCAPI {
    supportsCommand(cmd: TimeParametersCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Date | undefined>;
    set(dateAndTime: Date): Promise<void>;
}
export declare class TimeParametersCC extends CommandClass {
    ccCommand: TimeParametersCommand;
    interview(complete?: boolean): Promise<void>;
}
export declare class TimeParametersCCReport extends TimeParametersCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly dateAndTime: Date;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class TimeParametersCCGet extends TimeParametersCC {
}
interface TimeParametersCCSetOptions extends CCCommandOptions {
    dateAndTime: Date;
}
export declare class TimeParametersCCSet extends TimeParametersCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | TimeParametersCCSetOptions);
    dateAndTime: Date;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
