"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FibaroVenetianBlindCCGet = exports.FibaroVenetianBlindCCReport = exports.FibaroVenetianBlindCCSet = exports.FibaroVenetianBlindCC = exports.FibaroVenetianBlindCCCommand = exports.FibaroCC = exports.FibaroCCIDs = exports.getFibaroVenetianBlindTiltMetadata = exports.getFibaroVenetianBlindTiltValueId = exports.getFibaroVenetianBlindPositionMetadata = exports.getFibaroVenetianBlindPositionValueId = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const CommandClass_1 = require("../CommandClass");
const ManufacturerProprietaryCC_1 = require("../ManufacturerProprietaryCC");
const Constants_1 = require("./Constants");
/** Returns the ValueID used to store the current venetian blind position */
function getFibaroVenetianBlindPositionValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Manufacturer Proprietary"],
        endpoint,
        property: "fibaro",
        propertyKey: "venetianBlindsPosition",
    };
}
exports.getFibaroVenetianBlindPositionValueId = getFibaroVenetianBlindPositionValueId;
/** Returns the value metadata for venetian blind position */
function getFibaroVenetianBlindPositionMetadata() {
    return {
        ...core_1.ValueMetadata.Level,
        label: "Venetian blinds position",
    };
}
exports.getFibaroVenetianBlindPositionMetadata = getFibaroVenetianBlindPositionMetadata;
/** Returns the ValueID used to store the current venetian blind tilt */
function getFibaroVenetianBlindTiltValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Manufacturer Proprietary"],
        endpoint,
        property: "fibaro",
        propertyKey: "venetianBlindsTilt",
    };
}
exports.getFibaroVenetianBlindTiltValueId = getFibaroVenetianBlindTiltValueId;
/** Returns the value metadata for venetian blind tilt */
function getFibaroVenetianBlindTiltMetadata() {
    return {
        ...core_1.ValueMetadata.Level,
        label: "Venetian blinds tilt",
    };
}
exports.getFibaroVenetianBlindTiltMetadata = getFibaroVenetianBlindTiltMetadata;
var FibaroCCIDs;
(function (FibaroCCIDs) {
    FibaroCCIDs[FibaroCCIDs["VenetianBlind"] = 38] = "VenetianBlind";
})(FibaroCCIDs = exports.FibaroCCIDs || (exports.FibaroCCIDs = {}));
class FibaroCC extends ManufacturerProprietaryCC_1.ManufacturerProprietaryCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 2);
            this.fibaroCCId = this.payload[0];
            this.fibaroCCCommand = this.payload[1];
            this.payload = this.payload.slice(2);
            if (this.fibaroCCId === FibaroCCIDs.VenetianBlind &&
                !shared_1.staticExtends(new.target, FibaroVenetianBlindCC)) {
                return new FibaroVenetianBlindCC(driver, options);
            }
        }
        else {
            this.manufacturerId = Constants_1.MANUFACTURERID_FIBARO;
        }
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.fibaroCCId, this.fibaroCCCommand]),
            this.payload,
        ]);
        return super.serialize();
    }
}
exports.FibaroCC = FibaroCC;
var FibaroVenetianBlindCCCommand;
(function (FibaroVenetianBlindCCCommand) {
    FibaroVenetianBlindCCCommand[FibaroVenetianBlindCCCommand["Set"] = 1] = "Set";
    FibaroVenetianBlindCCCommand[FibaroVenetianBlindCCCommand["Get"] = 2] = "Get";
    FibaroVenetianBlindCCCommand[FibaroVenetianBlindCCCommand["Report"] = 3] = "Report";
})(FibaroVenetianBlindCCCommand = exports.FibaroVenetianBlindCCCommand || (exports.FibaroVenetianBlindCCCommand = {}));
class FibaroVenetianBlindCC extends FibaroCC {
    constructor(driver, options) {
        super(driver, options);
        this.fibaroCCId = FibaroCCIDs.VenetianBlind;
        if (CommandClass_1.gotDeserializationOptions(options)) {
            if (this.fibaroCCCommand === FibaroVenetianBlindCCCommand.Report &&
                (new.target) !== FibaroVenetianBlindCCReport) {
                return new FibaroVenetianBlindCCReport(driver, options);
            }
        }
    }
    async interview(complete = true) {
        const node = this.getNode();
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "Requesting venetian blind position and tilt...",
            direction: "outbound",
        });
        const resp = await this.driver.sendCommand(new FibaroVenetianBlindCCGet(this.driver, {
            nodeId: this.nodeId,
            endpoint: this.endpointIndex,
        }));
        if (resp) {
            const logMessage = `received venetian blind state:
position: ${resp.position}
tilt:     ${resp.tilt}`;
            this.driver.controllerLog.logNode(node.id, {
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
}
exports.FibaroVenetianBlindCC = FibaroVenetianBlindCC;
class FibaroVenetianBlindCCSet extends FibaroVenetianBlindCC {
    constructor(driver, options) {
        super(driver, options);
        this.fibaroCCCommand = FibaroVenetianBlindCCCommand.Set;
        if (Buffer.isBuffer(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if ("position" in options)
                this.position = options.position;
            if ("tilt" in options)
                this.tilt = options.tilt;
        }
    }
    serialize() {
        var _a, _b;
        const controlByte = (this.position != undefined ? 0b10 : 0) |
            (this.tilt != undefined ? 0b01 : 0);
        this.payload = Buffer.from([
            controlByte,
            (_a = this.position) !== null && _a !== void 0 ? _a : 0,
            (_b = this.tilt) !== null && _b !== void 0 ? _b : 0,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = {};
        if (this.position != undefined) {
            message.position = this.position;
        }
        if (this.tilt != undefined) {
            message.tilt = this.tilt;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
}
exports.FibaroVenetianBlindCCSet = FibaroVenetianBlindCCSet;
class FibaroVenetianBlindCCReport extends FibaroVenetianBlindCC {
    constructor(driver, options) {
        super(driver, options);
        this.fibaroCCCommand = FibaroVenetianBlindCCCommand.Report;
        core_1.validatePayload(this.payload.length >= 3);
        const valueDB = this.getValueDB();
        // When the node sends a report, payload[0] === 0b11. This is probably a
        // bit mask for position and tilt
        if (!!(this.payload[0] & 0b10)) {
            this.position = core_1.parseMaybeNumber(this.payload[1], driver.options.preserveUnknownValues);
            const positionValueId = getFibaroVenetianBlindPositionValueId(this.endpointIndex);
            valueDB.setMetadata(positionValueId, {
                ...core_1.ValueMetadata.Level,
                label: "Venetian blinds position",
            });
            valueDB.setValue(positionValueId, this.position);
        }
        if (!!(this.payload[0] & 0b01)) {
            this.tilt = core_1.parseMaybeNumber(this.payload[2], driver.options.preserveUnknownValues);
            const tiltValueId = getFibaroVenetianBlindTiltValueId(this.endpointIndex);
            valueDB.setMetadata(tiltValueId, {
                ...core_1.ValueMetadata.Level,
                label: "Venetian blinds tilt",
            });
            valueDB.setValue(tiltValueId, this.tilt);
        }
    }
    toLogEntry() {
        const message = {};
        if (this.position != undefined) {
            message.position = this.position;
        }
        if (this.tilt != undefined) {
            message.tilt = this.tilt;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
}
exports.FibaroVenetianBlindCCReport = FibaroVenetianBlindCCReport;
let FibaroVenetianBlindCCGet = class FibaroVenetianBlindCCGet extends FibaroVenetianBlindCC {
    constructor(driver, options) {
        super(driver, options);
        this.fibaroCCCommand = FibaroVenetianBlindCCCommand.Get;
    }
};
FibaroVenetianBlindCCGet = __decorate([
    CommandClass_1.expectedCCResponse(FibaroVenetianBlindCCReport)
], FibaroVenetianBlindCCGet);
exports.FibaroVenetianBlindCCGet = FibaroVenetianBlindCCGet;

//# sourceMappingURL=Fibaro.js.map
