"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetControllerCapabilitiesResponse = exports.GetControllerCapabilitiesRequest = void 0;
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
var ControllerCapabilityFlags;
(function (ControllerCapabilityFlags) {
    ControllerCapabilityFlags[ControllerCapabilityFlags["Secondary"] = 1] = "Secondary";
    ControllerCapabilityFlags[ControllerCapabilityFlags["OnOtherNetwork"] = 2] = "OnOtherNetwork";
    ControllerCapabilityFlags[ControllerCapabilityFlags["SISPresent"] = 4] = "SISPresent";
    ControllerCapabilityFlags[ControllerCapabilityFlags["WasRealPrimary"] = 8] = "WasRealPrimary";
    ControllerCapabilityFlags[ControllerCapabilityFlags["SUC"] = 16] = "SUC";
})(ControllerCapabilityFlags || (ControllerCapabilityFlags = {}));
let GetControllerCapabilitiesRequest = class GetControllerCapabilitiesRequest extends Message_1.Message {
};
GetControllerCapabilitiesRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.GetControllerCapabilities),
    Message_1.expectedResponse(Constants_1.FunctionType.GetControllerCapabilities),
    Message_1.priority(Constants_1.MessagePriority.Controller)
], GetControllerCapabilitiesRequest);
exports.GetControllerCapabilitiesRequest = GetControllerCapabilitiesRequest;
let GetControllerCapabilitiesResponse = class GetControllerCapabilitiesResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this._capabilityFlags = this.payload[0];
    }
    get isSecondary() {
        return !!(this._capabilityFlags & ControllerCapabilityFlags.Secondary);
    }
    get isUsingHomeIdFromOtherNetwork() {
        return !!(this._capabilityFlags & ControllerCapabilityFlags.OnOtherNetwork);
    }
    get isSISPresent() {
        return !!(this._capabilityFlags & ControllerCapabilityFlags.SISPresent);
    }
    get wasRealPrimary() {
        return !!(this._capabilityFlags & ControllerCapabilityFlags.WasRealPrimary);
    }
    get isStaticUpdateController() {
        return !!(this._capabilityFlags & ControllerCapabilityFlags.SUC);
    }
    toJSON() {
        return super.toJSONInherited({
            isSecondary: this.isSecondary,
            isUsingHomeIdFromOtherNetwork: this.isUsingHomeIdFromOtherNetwork,
            isSISPresent: this.isSISPresent,
            wasRealPrimary: this.wasRealPrimary,
            isStaticUpdateController: this.isStaticUpdateController,
        });
    }
};
GetControllerCapabilitiesResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.GetControllerCapabilities)
], GetControllerCapabilitiesResponse);
exports.GetControllerCapabilitiesResponse = GetControllerCapabilitiesResponse;

//# sourceMappingURL=GetControllerCapabilitiesMessages.js.map
