/// <reference types="node" />
import type { MessageOrCCLogEntry } from "@zwave-js/core";
import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
interface GetRoutingInfoRequestOptions extends MessageBaseOptions {
    nodeId: number;
    removeNonRepeaters?: boolean;
    removeBadLinks?: boolean;
}
export declare class GetRoutingInfoRequest extends Message {
    constructor(driver: Driver, options: GetRoutingInfoRequestOptions);
    nodeId: number;
    removeNonRepeaters: boolean;
    removeBadLinks: boolean;
    serialize(): Buffer;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class GetRoutingInfoResponse extends Message {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _nodeIds;
    get nodeIds(): number[];
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
