/// <reference types="node" />
import type { MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions, MessageOptions } from "../message/Message";
import type { MultiStageCallback, SuccessIndicator } from "../message/SuccessIndicator";
export declare enum NodeNeighborUpdateStatus {
    UpdateStarted = 33,
    UpdateDone = 34,
    UpdateFailed = 35
}
export interface RequestNodeNeighborUpdateRequestOptions extends MessageBaseOptions {
    nodeId: number;
}
export declare class RequestNodeNeighborUpdateRequestBase extends Message {
    constructor(driver: Driver, options: MessageOptions);
}
export declare class RequestNodeNeighborUpdateRequest extends RequestNodeNeighborUpdateRequestBase {
    constructor(driver: Driver, options: RequestNodeNeighborUpdateRequestOptions);
    nodeId: number;
    serialize(): Buffer;
    getCallbackTimeout(): number | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class RequestNodeNeighborUpdateReport extends RequestNodeNeighborUpdateRequestBase implements SuccessIndicator, MultiStageCallback {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    isFinal(): boolean;
    private _updateStatus;
    get updateStatus(): NodeNeighborUpdateStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
