import { Comparable, CompareResult } from "alcalzone-shared/comparable";
import type { DeferredPromise } from "alcalzone-shared/deferred-promise";
import { MessagePriority } from "../message/Constants";
import type { Message } from "../message/Message";
import type { Driver } from "./Driver";
/**
 * Transactions are used to track and correllate messages with their responses.
 */
export declare class Transaction implements Comparable<Transaction> {
    private readonly driver;
    readonly message: Message;
    readonly promise: DeferredPromise<Message | void>;
    priority: MessagePriority;
    constructor(driver: Driver, message: Message, promise: DeferredPromise<Message | void>, priority: MessagePriority);
    /** The timestamp at which the transaction was created */
    creationTimestamp: number;
    /** Whether the node status should be updated when this transaction times out */
    changeNodeStatusOnTimeout: boolean;
    /** Internal information used to identify or mark this transaction */
    tag?: any;
    /** The stack trace where the transaction was created */
    readonly stack: string;
    /** Compares two transactions in order to plan their transmission sequence */
    compareTo(other: Transaction): CompareResult;
    toJSON(): any;
}
