"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dummyMessageWithResponseWithCallback = exports.dummyMessageNoResponseWithCallback = exports.dummyMessageWithResponseNoCallback = exports.dummyMessageNoResponseNoCallback = exports.dummyMessageUnrelated = exports.dummyCallbackNOK = exports.dummyResponseNOK = exports.dummyCallbackPartial = exports.dummyCallbackOK = exports.dummyResponseOK = exports.createSendDataRejectsImmediately = exports.createSendDataResolvesImmediately = exports.createSendDataResolvesNever = void 0;
/* eslint-disable @typescript-eslint/explicit-module-boundary-types */
/* eslint-disable @typescript-eslint/no-empty-function */
const Constants_1 = require("../message/Constants");
const createSendDataResolvesNever = () => jest.fn().mockImplementation(() => new Promise(() => { }));
exports.createSendDataResolvesNever = createSendDataResolvesNever;
const createSendDataResolvesImmediately = () => jest.fn().mockResolvedValue(undefined);
exports.createSendDataResolvesImmediately = createSendDataResolvesImmediately;
const createSendDataRejectsImmediately = () => jest.fn().mockRejectedValue(new Error("nope"));
exports.createSendDataRejectsImmediately = createSendDataRejectsImmediately;
const defaultImplementations = {
    serialize: () => Buffer.from([1, 2, 3]),
    getNodeUnsafe: () => undefined,
    getNodeId: () => undefined,
    toLogEntry: () => ({ tags: [] }),
    needsCallbackId: () => true,
    getCallbackTimeout: () => undefined,
};
exports.dummyResponseOK = {
    type: Constants_1.MessageType.Response,
    expectedResponse: undefined,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => false,
    expectsCallback: () => false,
    isOK: () => true,
    ...defaultImplementations,
};
exports.dummyCallbackOK = {
    type: Constants_1.MessageType.Request,
    expectedResponse: undefined,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => false,
    expectsCallback: () => false,
    isOK: () => true,
    ...defaultImplementations,
};
exports.dummyCallbackPartial = {
    ...exports.dummyCallbackOK,
    isFinal: () => false,
};
exports.dummyResponseNOK = {
    type: Constants_1.MessageType.Response,
    expectedResponse: undefined,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => false,
    expectsCallback: () => false,
    isOK: () => false,
    ...defaultImplementations,
};
exports.dummyCallbackNOK = {
    type: Constants_1.MessageType.Request,
    expectedResponse: undefined,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => false,
    expectsCallback: () => false,
    isOK: () => false,
    ...defaultImplementations,
};
exports.dummyMessageUnrelated = {
    expectedResponse: undefined,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => false,
    expectsCallback: () => false,
    ...defaultImplementations,
};
exports.dummyMessageNoResponseNoCallback = {
    expectedResponse: undefined,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => false,
    expectsCallback: () => false,
    ...defaultImplementations,
};
exports.dummyMessageWithResponseNoCallback = {
    expectedResponse: 0xff,
    expectedCallback: undefined,
    hasCallbackId: () => false,
    expectsResponse: () => true,
    expectsCallback: () => false,
    isExpectedResponse: (msg) => msg === exports.dummyResponseOK || msg === exports.dummyResponseNOK,
    ...defaultImplementations,
};
exports.dummyMessageNoResponseWithCallback = {
    expectedResponse: undefined,
    expectedCallback: true,
    hasCallbackId: () => true,
    callbackId: 1,
    expectsResponse: () => false,
    expectsCallback: () => true,
    isExpectedCallback: (msg) => msg === exports.dummyCallbackOK || msg === exports.dummyCallbackNOK,
    ...defaultImplementations,
};
exports.dummyMessageWithResponseWithCallback = {
    expectedResponse: true,
    expectedCallback: true,
    expectsResponse: () => true,
    expectsCallback: () => true,
    isExpectedResponse: (msg) => msg === exports.dummyResponseOK || msg === exports.dummyResponseNOK,
    isExpectedCallback: (msg) => msg === exports.dummyCallbackOK || msg === exports.dummyCallbackNOK,
    ...defaultImplementations,
};

//# sourceMappingURL=messages.js.map
