/*! @sentry/integrations 6.19.7 (5b3a175) | https://github.com/getsentry/sentry-javascript */
(function (__window) {
var exports = {};

/**
 * NOTE: In order to avoid circular dependencies, if you add a function to this module and it needs to print something,
 * you must either a) use `console.log` rather than the logger, or b) put your function elsewhere.
 */
const fallbackGlobalObject = {};
/**
 * Safely get global scope object
 *
 * @returns Global scope object
 */
function getGlobalObject() {
    return (typeof window !== 'undefined' // eslint-disable-line no-restricted-globals
            ? window // eslint-disable-line no-restricted-globals
            : typeof self !== 'undefined'
                ? self
                : fallbackGlobalObject);
}

/**
 * Tells whether current environment supports ReportingObserver API
 * {@link supportsReportingObserver}.
 *
 * @returns Answer to the given question.
 */
function supportsReportingObserver() {
    return 'ReportingObserver' in getGlobalObject();
}

/** Reporting API integration - https://w3c.github.io/reporting/ */
class ReportingObserver {
    /**
     * @inheritDoc
     */
    constructor(_options = {
        types: ['crash', 'deprecation', 'intervention'],
    }) {
        this._options = _options;
        /**
         * @inheritDoc
         */
        this.name = ReportingObserver.id;
    }
    /**
     * @inheritDoc
     */
    setupOnce(_, getCurrentHub) {
        if (!supportsReportingObserver()) {
            return;
        }
        this._getCurrentHub = getCurrentHub;
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access, @typescript-eslint/no-explicit-any
        const observer = new (getGlobalObject().ReportingObserver)(this.handler.bind(this), {
            buffered: true,
            types: this._options.types,
        });
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        observer.observe();
    }
    /**
     * @inheritDoc
     */
    handler(reports) {
        const hub = this._getCurrentHub && this._getCurrentHub();
        if (!hub || !hub.getIntegration(ReportingObserver)) {
            return;
        }
        for (const report of reports) {
            hub.withScope(scope => {
                scope.setExtra('url', report.url);
                const label = `ReportingObserver [${report.type}]`;
                let details = 'No details available';
                if (report.body) {
                    // Object.keys doesn't work on ReportBody, as all properties are inheirted
                    const plainBody = {};
                    // eslint-disable-next-line guard-for-in
                    for (const prop in report.body) {
                        plainBody[prop] = report.body[prop];
                    }
                    scope.setExtra('body', plainBody);
                    if (report.type === 'crash') {
                        const body = report.body;
                        // A fancy way to create a message out of crashId OR reason OR both OR fallback
                        details = [body.crashId || '', body.reason || ''].join(' ').trim() || details;
                    }
                    else {
                        const body = report.body;
                        details = body.message || details;
                    }
                }
                hub.captureMessage(`${label}: ${details}`);
            });
        }
    }
}
/**
 * @inheritDoc
 */
ReportingObserver.id = 'ReportingObserver';

exports.ReportingObserver = ReportingObserver;


  // Add this module's exports to the global `Sentry.Integrations`
  __window.Sentry = __window.Sentry || {};
  __window.Sentry.Integrations = __window.Sentry.Integrations || {};
  for (var key in exports) {
    if (Object.prototype.hasOwnProperty.call(exports, key)) {
      __window.Sentry.Integrations[key] = exports[key];
    }
  }
}(window));
//# sourceMappingURL=reportingobserver.es6.js.map
