import { EventProcessor, Hub, Integration } from '@sentry/types';
interface Report {
    [key: string]: unknown;
    type: ReportTypes;
    url: string;
    body?: ReportBody;
}
declare type ReportTypes = 'crash' | 'deprecation' | 'intervention';
declare type ReportBody = CrashReportBody | DeprecationReportBody | InterventionReportBody;
interface CrashReportBody {
    [key: string]: unknown;
    crashId: string;
    reason?: string;
}
interface DeprecationReportBody {
    [key: string]: unknown;
    id: string;
    anticipatedRemoval?: Date;
    message: string;
    sourceFile?: string;
    lineNumber?: number;
    columnNumber?: number;
}
interface InterventionReportBody {
    [key: string]: unknown;
    id: string;
    message: string;
    sourceFile?: string;
    lineNumber?: number;
    columnNumber?: number;
}
/** Reporting API integration - https://w3c.github.io/reporting/ */
export declare class ReportingObserver implements Integration {
    private readonly _options;
    /**
     * @inheritDoc
     */
    static id: string;
    /**
     * @inheritDoc
     */
    readonly name: string;
    /**
     * Returns current hub.
     */
    private _getCurrentHub?;
    /**
     * @inheritDoc
     */
    constructor(_options?: {
        types?: ReportTypes[];
    });
    /**
     * @inheritDoc
     */
    setupOnce(_: (callback: EventProcessor) => void, getCurrentHub: () => Hub): void;
    /**
     * @inheritDoc
     */
    handler(reports: Report[]): void;
}
export {};
//# sourceMappingURL=reportingobserver.d.ts.map