let warningSent = false

const wrapWithHiddenComName = async portsPromise => {
  const ports = await portsPromise
  return ports.map(port => {
    const newPort = { ...port }
    return Object.defineProperties(newPort, {
      comName: {
        get() {
          if (!warningSent) {
            warningSent = true
            console.warn(
              `"PortInfo.comName" has been deprecated. You should now use "PortInfo.path". The property will be removed in the next major release.`
            )
          }
          return newPort.path
        },
        enumerable: false,
      },
    })
  })
}

module.exports = {
  wrapWithHiddenComName,
}
