import type { CommandClasses, CommandClassInfo, ValueID } from "@zwave-js/core";
import type { JSONObject } from "@zwave-js/shared";
export declare class CompatConfig {
    private valueIdRegex;
    constructor(filename: string, definition: JSONObject);
    readonly addCCs?: ReadonlyMap<CommandClasses, CompatAddCC>;
    readonly removeCCs?: ReadonlyMap<CommandClasses, "*" | readonly number[]>;
    readonly disableBasicMapping?: boolean;
    readonly overrideFloatEncoding?: {
        size?: number;
        precision?: number;
    };
    readonly preserveRootApplicationCCValueIDs?: boolean;
    readonly skipConfigurationInfoQuery?: boolean;
    readonly treatBasicSetAsEvent?: boolean;
    readonly manualValueRefreshDelayMs?: number;
    readonly queryOnWakeup?: readonly [
        string,
        string,
        ...(string | number | boolean | Pick<ValueID, "property" | "propertyKey">)[]
    ][];
}
export declare class CompatAddCC {
    constructor(filename: string, definition: JSONObject);
    readonly endpoints: ReadonlyMap<number, Partial<CommandClassInfo>>;
}
//# sourceMappingURL=CompatConfig.d.ts.map